% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wp.R
\name{wp}
\alias{wp}
\title{Weierstrass elliptic function}
\usage{
wp(z, g = NULL, omega = NULL, tau = NULL, derivative = 0L)
}
\arguments{
\item{z}{complex number, vector or matrix}

\item{g}{the elliptic invariants, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{omega}{the half-periods, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{tau}{the half-periods ratio; supplying \code{tau} is equivalent to 
supply \code{omega = c(1/2, tau/2)}}

\item{derivative}{differentiation order, an integer between 0 and 3}
}
\value{
A complex number, vector or matrix.
}
\description{
Evaluation of the Weierstrass elliptic function and its 
  derivatives.
}
\examples{
omega1 <- 1.4 - 1i
omega2 <- 1.6 + 0.5i
omega <- c(omega1, omega2)
e1 <- wp(omega1, omega = omega)
e2 <- wp(omega2, omega = omega)
e3 <- wp(-omega1-omega2, omega = omega)
e1 + e2 + e3 # should be 0
}
