% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate.R
\name{crossplot}
\alias{crossplot}
\title{Bivariate Plot of Posterior Densities}
\usage{
crossplot(
  dfx,
  dfy = NULL,
  p = NULL,
  col = 4,
  drawcross = TRUE,
  drawx = FALSE,
  drawblob = FALSE,
  blobres = NULL,
  blobsmooth = NULL,
  outline = FALSE,
  ci = c(0.5, 0.95),
  lwd = 1,
  mean = FALSE,
  link = FALSE,
  linklwd = 1,
  labels = FALSE,
  labelpos = NULL,
  labelcex = 0.7,
  whichx = NULL,
  rowx = NULL,
  columnx = NULL,
  whichy = NULL,
  rowy = NULL,
  columny = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  transformx = c("none", "exp", "expit"),
  transformy = c("none", "exp", "expit"),
  add = FALSE,
  ...
)
}
\arguments{
\item{dfx}{Output object returned from \code{jagsUI::jags()}; or alternately,
two-dimensional \code{data.frame} or matrix in which parameter node element is
given by column and MCMC iteration is given by row.  A vector may also be used,
that expresses MCMC iterations of a single parameter node.  If used with \verb{dfy=},
this will be plotted in the x-direction.}

\item{dfy}{Optionally, a
two-dimensional \code{data.frame} or matrix in which parameter node element is
given by column and MCMC iteration is given by row.  A vector may also be used,
that expresses MCMC iterations of a single parameter node.  If used, this will
be plotted in the y-direction.}

\item{p}{Vector of parameter names, if input to \code{dfx} is a \code{jagsUI} output object.
If used, this must be of length 2.}

\item{col}{Color for plotting, or recyclable vector of colors.  Defaults to \code{4}.
If \code{col == "random"}, \link{rcolors} will be used to generate a random vector of colors.}

\item{drawcross}{Whether to draw quantile bars in the x- and y-directions.
Defaults to \code{TRUE}.}

\item{drawx}{Whether to draw quantile bars along the standardized principal component axes.
Defaults to \code{FALSE}.}

\item{drawblob}{Whether to draw smoothed quantile polygons.
Defaults to \code{FALSE}.}

\item{blobres}{Optional tuning parameter for drawing quantile polygons, and
corresponds to the number of polygon vertices.  If the default \code{NULL} is accepted,
the function will supply a value based on the number of MCMC samples.}

\item{blobsmooth}{Optional tuning parameter for drawing quantile polygons, and
corresponds to half the number of polygon vertices used for local smoothing.
If the default \code{NULL} is accepted,
the function will supply a value based on the number of MCMC samples and the
number of vertices.}

\item{outline}{Whether to draw quantile polygons as lines rather than filled regions.  Defaults to \code{FALSE}.}

\item{ci}{Vector of intervals to overlay.  Defaults to 50 percent and 95 percent.}

\item{lwd}{Base line width for plotting.  Defaults to 1.}

\item{mean}{Whether to include points for means.  Defaults to \code{FALSE}.}

\item{link}{Whether to link medians in sequence.  Defaults to \code{FALSE}.}

\item{linklwd}{Line width to use for linking.  Defaults to \code{1}.}

\item{labels}{Whether to add labels, or a vector of labels to add.  Defaults to \code{FALSE}.}

\item{labelpos}{Optionally, an argument to \code{pos} in \link[graphics]{text} for labels.  Defaults to \code{NULL}.}

\item{labelcex}{Optional character expansion for labels.  Defaults to \code{0.7}.}

\item{whichx}{Element to subset for x, if only one element of a  vector of parameter nodes is desired for plotting.}

\item{rowx}{Row to subset for x, in the case of a 2-d matrix of parameter nodes in-model.}

\item{columnx}{Column to subset for x, in the case of a 2-d matrix of parameter nodes in-model.}

\item{whichy}{Element to subset for x, if only one element of a  vector of parameter nodes is desired for plotting.}

\item{rowy}{Row to subset for y, in the case of a 2-d matrix of parameter nodes in-model.}

\item{columny}{Column to subset for y, in the case of a 2-d matrix of parameter nodes in-model.}

\item{xlab}{X-axis label.  If the default \code{NULL} is accepted, this will be drawn automatically.}

\item{ylab}{Y-axis label.  If the default \code{NULL} is accepted, this will be drawn automatically.}

\item{main}{Plot title.}

\item{xlim}{X-axis limits.  If the default (\code{NULL}) is accepted, the limits will be determined automatically.}

\item{ylim}{Y-axis limits.  If the default (\code{NULL}) is accepted, the limits will be determined automatically.}

\item{transformx}{Should the x-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transformx="exp"}is used, consider
adding additional plotting argument \code{log="x"} or \code{log="xy"}.}

\item{transformy}{Should the y-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transformy="exp"}is used, consider
adding additional plotting argument \code{log="y"} or \code{log="xy"}.}

\item{add}{Whether to add to existing plot}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Bivariate plot of the posterior densities of corresponding vectors
of parameter nodes.  Three plotting methods are provided, that may be overlayed
if desired.
\itemize{
\item If \code{drawcross == TRUE}, \link{caterpillar}-like plots will be produced, with quantile
intervals in the x- and y- directions.
\item If \code{drawx == TRUE}, \link{caterpillar}-like plots will be produced, but rotated
along the standardized principal component axes.  This may be useful to draw if correlation
is present.
\item If \code{drawblob == TRUE}, smoothed polygons will be produced, each containing
approximately \verb{ci=} x100\% of the associated MCMC samples.
}

All methods can overlay multiple bars or polygons, depending on the length of \verb{ci=}.
}
\examples{
## basic functionality with cross geometry
crossplot(SS_out, p=c("trend","rate"))

## default labels
crossplot(SS_out, p=c("trend","cycle"), labels=TRUE)

## showing:
## - link lines
## - blob geometry (smoothed confidence polygons)
## - random colors with col="random"
crossplot(SS_out, p=c("trend","cycle"),
          labels=SS_data$x, labelpos=1, link=TRUE, drawblob=TRUE,
          col="random")

## adding x geometry and showing usage with a single vector element (41)
crossplot(SS_out, p=c("trend","cycle"),
          whichx=41, whichy=41,
          drawblob=TRUE, drawx=TRUE)

## single vectors (or data.frames or 2d matrices) can also be used
xx <- SS_out$sims.list$trend[,41]
yy <- SS_out$sims.list$cycle[,41]

par(mfrow = c(2, 2))
plot(xx, yy, col=adjustcolor(1, alpha.f=.1), pch=16, main="cross geometry")
crossplot(xx, yy, add=TRUE, col=1)
plot(xx, yy, col=adjustcolor(1, alpha.f=.1), pch=16, main="x geometry")
crossplot(xx, yy, add=TRUE, col=1,
          drawcross=FALSE, drawx=TRUE)
plot(xx, yy, col=adjustcolor(1, alpha.f=.1), pch=16, main="blob geometry")
crossplot(xx, yy, add=TRUE, col=1,
          drawcross=FALSE, drawblob=TRUE)
plot(xx, yy, col=adjustcolor(1, alpha.f=.1), pch=16, main="blob outlines")
crossplot(xx, yy, add=TRUE, col=1,
          drawcross=FALSE, drawblob=TRUE, outline=TRUE)
}
\seealso{
\link{caterpillar}, \link{pairstrace_jags}
}
\author{
Matt Tyers
}
