% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{adjustAxisLabelMargins}
\alias{adjustAxisLabelMargins}
\title{Adjust axis label margins}
\usage{
adjustAxisLabelMargins(
  x,
  margin = 1,
  maxFig = 1/2,
  cex = graphics::par("cex"),
  cex.axis = graphics::par("cex.axis"),
  prefix = "-- -- ",
  ...
)
}
\arguments{
\item{x}{\code{character} vector of axis labels}

\item{margin}{\code{integer} value indicating which margin to adjust,
using the order by \code{graphics::par("mar")}, 1=bottom, 2=left, 3=top,
4=right.}

\item{maxFig}{\code{numeric} fraction less than 1, indicating the maximum
size of margin relative to the figure size. Setting margins too
large results in an error otherwise.}

\item{cex}{\code{numeric} or NULL, default \code{graphics::par("cex")},
used as a convenience with \code{cex * cex.axis} passed to
\code{graphics::strwidth()}.
However, \code{graphics::axis()} itself should use \code{cex.axis} when
adjusting axis label font size.}

\item{cex.axis}{\code{numeric}, default \code{graphics::par("cex.axis")} to define
the axis label font size.}

\item{prefix}{\code{character} string to add whitespace around the axis label
in order to add a "buffer" of whitespace.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{list} named "mai" suitable for use in \code{graphics::par()}
to adjust margin size using in inches.
}
\description{
Adjust axis label margins to accommodate axis labels
}
\details{
This function takes a vector of axis labels, and the margin where they
will be used, and adjusts the relevant axis margin to accomodate the
label size, up to a maximum fraction of the figure size as defined by
\code{maxFig}.

Labels are assumed to be perpendicular to the axis, for example
argument \code{las=2} when using \code{graphics::text()}.

Note this function does not render labels in the figure, and therefore
does not revert axis margins to their original size. That process
should be performed separately.
}
\examples{
xlabs <- paste0("item_", (1:20));
ylabs <- paste0("rownum_", (1:20));

# proper adjustment should be done using withr, for example
x_cex <- 0.8;
y_cex <- 1.2;
withr::with_par(adjustAxisLabelMargins(xlabs, 1, cex.axis=x_cex), {
   withr::local_par(adjustAxisLabelMargins(ylabs, 2, cex.axis=y_cex))
   nullPlot(xlim=c(1,20), ylim=c(1,20), doMargins=FALSE);
   graphics::axis(1, at=1:20, labels=xlabs, las=2, cex.axis=x_cex);
   graphics::axis(2, at=1:20, labels=ylabs, las=2, cex.axis=y_cex);
})

withr::with_par(adjustAxisLabelMargins(xlabs, 3, cex.axis=x_cex), {
   withr::local_par(adjustAxisLabelMargins(ylabs, 4, cex.axis=y_cex))
   nullPlot(xlim=c(1,20), ylim=c(1,20), doMargins=FALSE);
   graphics::axis(3, at=1:20, labels=xlabs, las=2);
   graphics::axis(4, at=1:20, labels=ylabs, las=2);
})

par("mar")
}
\seealso{
Other jam plot functions: 
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
