% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-drawlabels.R
\name{drawLabels}
\alias{drawLabels}
\title{Draw text labels on a base R plot}
\usage{
drawLabels(
  txt = NULL,
  newCoords = NULL,
  x = NULL,
  y = NULL,
  lx = NULL,
  ly = NULL,
  segmentLwd = 1,
  segmentCol = "#00000088",
  drawSegments = TRUE,
  boxBorderColor = "#000000AA",
  boxColor = "#FFEECC",
  boxLwd = 1,
  drawBox = TRUE,
  drawLabels = TRUE,
  font = 1,
  labelCex = 0.8,
  boxCexAdjust = 1.9,
  labelCol = alpha2col(alpha = 0.8, setTextContrastColor(boxColor)),
  doPlot = TRUE,
  xpd = NA,
  preset = "default",
  adjPreset = "default",
  preset_type = "plot",
  adjX = 0.5,
  adjY = 0.5,
  panelWidth = "default",
  trimReturns = TRUE,
  text_fn = getOption("jam.text_fn", graphics::text),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{txt}{\code{character} vector of labels, length equal to \code{x} and \code{y}.}

\item{newCoords}{\code{data.frame} optional, typically as a result of
a previous call to \code{drawLabels()}. In general, it should contain
colnames equivalent to the function parameters of \code{drawLabels()}.}

\item{x, y}{\code{numeric} vector of x- and y- coordinates.}

\item{lx, ly}{\code{numeric} optional vector of segment endpoint coordinates, used
to draw a line from x,y coordinates to the segment lx,ly coordinate.}

\item{segmentLwd, segmentCol}{\code{numeric} vector of segment line widths,
and \code{character} colors, respectively.
Each vector will be recycled to \code{length(txt)} as needed.}

\item{drawSegments}{\code{logical} whether to draw segments, where applicable.}

\item{boxBorderColor}{\code{character} vector of colors used for the
box border around each label.}

\item{boxColor}{\code{character} vector of colors used for the box background
behind each label.}

\item{boxLwd}{\code{numeric} vector of box line widths, sent to
\code{graphics::rect()}, this vector will be recycled to \code{length(txt)}.}

\item{drawBox}{\code{logical} whether to draw boxes behind each text label.}

\item{drawLabels}{\code{logical} whether to draw each text label.}

\item{font}{\code{integer} vector of font values as described in
\code{graphics::par()}, where 1=normal, 2=bold, 3=italics, 4=bold-italics.}

\item{labelCex}{\code{numeric} vector of cex values used for text labels,
recycled to \code{length(txt)} as needed.}

\item{boxCexAdjust}{\code{numeric} vector length=2, used to expand the x-width
and y-height of the box around around text labels.}

\item{labelCol}{\code{character} vector of label colors, by default it calls
\code{jamba::setTextContrastColor()} to generate a color to contrast
the background box color.}

\item{doPlot}{\code{logical} whether to perform any plot operations. Set
\code{FALSE} to calculate coordinates and return a \code{data.frame} of
label coordinates, which can then be manipulated before calling
\code{drawLabels()} again.}

\item{xpd}{\code{logical} value compatible with \code{graphics::par("xpd")}, where NA allows labels
anywhere in the device region, TRUE retricts labels within the figure
region, and FALSE restricts labels within the plot region.}

\item{preset}{\code{character} vector passed to \code{coordPresets()}
used to position text labels relative
to the x,y coordinate, where "topleft" will position the label so the
entire label box is top-left of the point, therefore the point will be
at the bottom-right corner of the label box. When \code{preset} is anything
by \code{"none"} the \code{adjX} and \code{adjY} values are ignored.}

\item{preset_type, adjPreset}{\code{character} passed to \code{coordPresets()} to
define orientation of each label relative to the \code{x},\code{y} coordinate.}

\item{adjX, adjY}{\code{numeric} the text adjustment of labels relative to the x,y
coordinate. The values are recycled to \code{length(txt)}.}

\item{panelWidth}{\code{character} string or vector, recycled to the number
of labels to be displayed. The argument indicates whether to size
each label box relative to the plot panel width, intended when
the label \code{preset} and \code{adjPreset} are set for the label to be inside
the plot panel, e.g. \verb{preset="top", adjPreset="top"}, or
\verb{preset="topleft", adjPreset="topright"}. Either both are centered,
or one is "right" and the other is "left". In these cases, the label
box is expanded to the full plot panel width, thus filling the full
visible x-axis range for the plot panel. Allowed values for \code{panelWidth}:
\itemize{
\item \code{"default"} size label boxes by text dimensions
\item \code{"force"} size label to full plot panel width
\item \code{"minimum"} size label at least the plot panel width, or larger if
necessary to fit the text label
\item \code{"maximum"} size label to the text label width, but no larger than
the plot panel width
}}

\item{trimReturns}{\code{logical} whether to trim leading and trailing return
(newline) characters from labels.}

\item{text_fn}{\code{function} used to render text, by default it checks
\code{getOption("jam.text_fn", graphics::text)} which then defaults
to \code{graphics::text}.
\itemize{
\item This argument is specifically to enable \code{jamba::shadowText()},
for example \code{text_fn=jamba::shadowText}.
\item Previous to version 0.0.107.900, one could assign
\code{text <- jamba::shadowText} however that option was removed
to make jamba more compliant with recommended R code, and
ready for CRAN.
}}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{...}{additional arguments are passed to \code{graphics::segments()} when
segments are drawn, to \code{graphics::rect()} when label boxes are drawn,
and to \code{graphics::text()} when text labels are drawn.}
}
\value{
invisible data.frame containing label coordinates used
to draw labels. This data.frame can be manipulated and provided
as input to \code{drawLabels()} for subsequent customized label
positioning.
}
\description{
Draw text labels on a base R plot
}
\details{
This function takes a vector of coordinates and text labels,
and draws the labels with colored rectangles around each label
on the plot. Each label can have unique font, cex, and color,
and are drawn using vectorized operations.

To enable shadow text include argument: \code{text_fn=jamba::shadowText}

TODO: In future allow rotated text labels. Not that useful within
a plot panel, but sometimes useful when draw outside a plot, for
example axis labels.
}
\examples{
nullPlot(plotAreaTitle="");
dl_topleft <- drawLabels(x=graphics::par("usr")[1],
   y=graphics::par("usr")[4],
   txt="Top-left\nof plot",
   preset="topleft",
   boxColor="blue4");

drawLabels(x=graphics::par("usr")[2],
   y=graphics::par("usr")[3],
   txt="Bottom-right\nof plot",
   preset="bottomright",
   boxColor="green4");

drawLabels(x=mean(graphics::par("usr")[1:2]),
   y=mean(graphics::par("usr")[3:4]),
   txt="Center\nof plot",
   preset="center",
   boxColor="purple3");

graphics::points(x=c(graphics::par("usr")[1], graphics::par("usr")[2],
      mean(graphics::par("usr")[1:2])),
   y=c(graphics::par("usr")[4], graphics::par("usr")[3],
      mean(graphics::par("usr")[3:4])),
   pch=20,
   col="red",
   xpd=NA);

nullPlot(plotAreaTitle="");
graphics::title(main="place label across the full top plot panel", line=2.5)
dl_top <- drawLabels(
   txt=c("preset='topright', adjPreset='topright', \npanelWidth='force'",
      "preset='topright',\nadjPreset='bottomleft'",
      "preset='bottomleft', adjPreset='topright',\npanelWidth='force'"),
   preset=c("topright", "topright", "bottomleft"),
   adjPreset=c("topleft", "bottomleft", "topright"),
   panelWidth=c("force", "none", "force"),
   boxColor=c("red4",
      "blue4",
      "purple3"));
graphics::box(lwd=2);

withr::with_par(list("mfrow"=c(1, 3), "xpd"=TRUE), {

isub <- c(force="Always full panel width",
   minimum="At least full panel width or larger",
   maximum="No larger than panel width");
for (i in c("force", "minimum", "maximum")) {
nullPlot(plotAreaTitle="", doMargins=FALSE);
graphics::title(main=paste0("panelWidth='", i, "'\n",
   isub[i]));
drawLabels(labelCex=1.2,
   txt=c("Super-wide title across the top\npanelWidth='force'",
   "bottom label"),
   preset=c("top", "bottom"),
   panelWidth=i,
   boxColor="red4")
}
})

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
