% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{gsubs}
\alias{gsubs}
\title{Pattern replacement with multiple patterns}
\usage{
gsubs(
  pattern,
  replacement,
  x,
  ignore.case = TRUE,
  replaceMultiple = rep(TRUE, length(pattern)),
  ...
)
}
\arguments{
\item{pattern}{\code{character} vector of patterns}

\item{replacement}{\code{character} vector of replacements}

\item{x}{\code{character} vector with input data to be curated}

\item{ignore.case}{\code{logical} indicating whether to perform
pattern matching in case-insensitive manner, where
\code{ignore.case=TRUE} will ignore the uppercase/lowercase
distinction.}

\item{replaceMultiple}{\code{logical} vector indicating whether to perform
global substitution, where \code{replaceMultiple=FALSE} will
only replace the first occurrence of the pattern, using
\code{base::sub()}. Note that this vector can refer to individual
entries in \code{pattern}.}

\item{...}{additional arguments are passed to \code{base::gsub()}
or \code{base::sub()}.}
}
\value{
\code{character} vector when input \code{x} is an atomic vector,
or \code{list} when input \code{x} is a \code{list}.
}
\description{
Pattern replacement with multiple patterns
}
\details{
This function is a simple wrapper around \code{base::gsub()}
when considering a series of pattern-replacement
combinations. It applies each pattern match and replacement
in order and is therefore not vectorized.

When \code{x} input is a \code{list} each vector in the \code{list} is processed,
somewhat differently than processing one vector.
\enumerate{
\item When the \code{list} contains another \code{list}, or when \code{length(x) < 100},
each value in \code{x} is iterated calling \code{gsubs()}.
This process is the slowest option, however not noticeble until
\code{x} has length over 10,000.
\item When the \code{list} does not contain another \code{list} and all values are
non-factor, or all values are \code{factor}, they are unlisted,
processed as a vector, then relisted. This process is nearly the
same speed as processing one single vector, except the time it
takes to confirm the list element classes.
\item When values contain a mix of non-factor and \code{factor} values, they
are separately unlisted, processed by \code{gsubs()}, then relisted
and combined afterward. Again, this process is only slightly slower
than option 2 above, given that it calls \code{gsubs()} twice, with two
vectors.
\item Note that \code{factor} values at input are
replaced with \code{character} values at output, consistent with \code{gsub()}.
}
}
\examples{
gsubs(c("one", "two"), c("three", "four"), "one two five six")
gsubs(c("one", "two"), c("three"), "one two five six")

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
