% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{jam_rapply}
\alias{jam_rapply}
\title{Jam-specific recursive apply}
\usage{
jam_rapply(x, FUN, how = c("unlist", "list"), ...)
}
\arguments{
\item{x}{\code{list}}

\item{FUN}{\code{function} to be called on non-list elements in \code{x}.}

\item{how}{\code{character} string indicating whether to return the
\code{list} or whether to call \code{unlist()} on the result.}

\item{...}{additional arguments are passed to \code{FUN}.}
}
\value{
\code{vector} or \code{list} based upon argument \code{how}.
}
\description{
Jam-specific recursive apply
}
\details{
This function is a very lightweight customization to \code{base::rapply()},
specifically that it does not remove \code{NULL} entries.
}
\examples{
L <- list(entryA=c("miR-112", "miR-12", "miR-112"),
   entryB=factor(c("A","B","A","B"),
      levels=c("B","A")),
   entryC=factor(c("C","A","B","B","C"),
      levels=c("A","B","C")),
   entryNULL=NULL)
rapply(L, length)
jam_rapply(L, length)

L0 <- list(A=1:3, B=list(C=1:3, D=4:5, E=NULL));
rapply(L0, length)
jam_rapply(L0, length)

}
\seealso{
Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{heads}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
