% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-kable-coloring.R
\name{kable_coloring}
\alias{kable_coloring}
\title{Extend kableExtra colorization of 'Rmarkdown' tables}
\usage{
kable_coloring(
  df,
  colorSub = NULL,
  background_as_tile = TRUE,
  color_cells = TRUE,
  row_color_by = NULL,
  sep = "_",
  border_left = "1px solid #DDDDDD",
  border_right = FALSE,
  extra_css = "white-space: nowrap;",
  format = "html",
  format.args = list(trim = TRUE, big.mark = ","),
  row.names = NA,
  align = NULL,
  return_type = c("kable", "data.frame"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df}{\code{data.frame} input. Note that \code{kable} input is not supported.}

\item{colorSub}{one of the following inputs:
\itemize{
\item \code{character} vector of R colors, whose names match entries
in the \code{data.frame} which are given these assigned colors
\item \code{function} that takes column values as input, and returns
a \code{character} vector with one color per value, using \code{NA}
or \code{NULL} to indicate \code{"transparent"}
\item \code{list} whose names match \code{colnames(df)}, where each entry
contains either \code{character} or \code{function} option as described
above. A \code{character} vector should be named by values expected
in each column. A \code{function} should take column values as input,
and return a \code{character} vector with same length of R colors.
}}

\item{background_as_tile}{\code{logical} default \code{TRUE}, whether the
cell background color will appear as a rounded tile (\code{TRUE})
or a rectangle (\code{FALSE}).
Either way, the color does not fill the entire whitespace
of the table cell, but only around the text itself.}

\item{color_cells}{\code{logical} indicating whether to color individual cells,
default \code{TRUE}. This may be \code{FALSE} when also applying \code{row_color_by},
so the entire row will be colorized.}

\item{row_color_by}{\code{character} vector with one or more \code{colnames},
indicating how to colorize entire rows of a table.
When one column is defined, colors in \code{colorSub} are used as normal.
When multiple columns are defined, values from each column are
concatenated using \code{sep} delimiter. Then resulting values are
compared with \code{colorSub}.}

\item{sep}{\code{character} delimiter used to combine values in multiple
columns when \code{row_color_by} is supplied and contains multiple
\code{colnames}. The delimited character strings are compared to
\code{colorSub} to assign colors.}

\item{border_left, border_right, extra_css}{\code{character} values optionally
passed to \code{kableExtra::column_spec()} as a convenient way to apply
borders for each column (\code{border_left}, \code{border_right}) or enable
or disable word-wrapping by column. Some helpful examples:
\itemize{
\item \code{border_left=FALSE}: disables left border
\item \code{border_left="1px solid #DDDDDD"}: light gray 1 pixel left border
\item \code{border_right=FALSE}: disables right border
\item \code{border_right="1px solid #DDDDDD"}: light gray 1 pixel right border
\item \code{extra_css=NULL}: disables word-wrap
\item \code{extra_css="whitespace: nowrap;"}: enables text word-wrap
\item when all options above contain only \code{FALSE} or \code{NULL}, then
\code{kableExtra::column_spec()} is not applied.
}}

\item{format}{\code{character} passed to \code{knitr::kable()}, default \code{"html"}
which is the intended format for most scenarios.
It can be set to \code{NULL} to enable auto-detection of the format.}

\item{format.args}{\code{list} of arguments passed to \code{base::format()}
intended mainly for \code{numeric} columns.}

\item{row.names}{\code{logical} indicating whether to include \code{rownames(df)}.
When \code{row.names=NA} the default is to display rownames if they
are not \code{NULL} and not equal to \code{1:nrow(df)}.}

\item{align}{\code{character} passed to \code{kableExtra::kable()} to define
alignment of each column.}

\item{return_type}{\code{character} string indicating the type of data
to return.
\itemize{
\item \code{return_type="kable"}: (default) returns object with class
\verb{"kableExtra", "knitr_kable"} suitable for downstream processing.
\item \code{return_type="data.frame"}: returns a \code{data.frame} whose cells
contain HTML markup with corresponding colors defined.
}}

\item{verbose}{boolean indicating whether to print verbose output.}

\item{...}{additional arguments are passed to \code{kableExtra::kable()}
which allows the usual customizations on the initial call.}
}
\value{
object with class \code{c("kableExtra", "knitr_kable")} by default
when \code{return_type="kable"}, suitable to render inside an 'Rmarkdown'
or HTML context. Or returns \code{data.frame} when \code{return_type="data.frame"}.
}
\description{
Extend kableExtra colorization of 'Rmarkdown' tables
}
\details{
This function extends the \code{kableExtra} package, and is only
available for use if the \code{kableExtra} package is installed. It is
intended to allow specific color assignment of elements in a
data.frame, but otherwise uses the \code{kableExtra} functions to
apply those colors.

The use case is to provide colorized HTML output for 'Rmarkdown',
it has not been tested with other \code{format} output.

The argument \code{colorSub} accepts:
\itemize{
\item \code{character} vector input where
names should match column values
\item \code{function} that accepts column values and returns a \code{character}
vector of colors of equal length
\item \code{list} input where names should match \code{colnames(df)}, and where
each list element should contain either a \code{character} vector, or
\code{function} as described above.
}
}
\examples{
\dontshow{if (all(check_pkg_installed(c("circlize", "kableExtra")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
expt_df <- data.frame(
   Sample_ID="",
   Treatment=rep(c("Vehicle", "Dex"), each=6),
   Genotype=rep(c("Wildtype", "Knockout"), each=3),
   Rep=paste0("rep", c(1:3)))
expt_df$Sample_ID <- pasteByRow(expt_df[, 2:4])

# define colors
colorSub <- c(Vehicle="palegoldenrod",
   Dex="navy",
   Wildtype="gold",
   Knockout="firebrick",
   nameVector(
      color2gradient("grey48", n=3, dex=10),
      rep("rep", 3),
      suffix=""),
   nameVector(
      color2gradient(n=3,
         c("goldenrod1", "indianred3", "royalblue3", "darkorchid4")),
      expt_df$Sample_ID))
kbl <- kable_coloring(
   expt_df,
   caption="Experiment design table showing categorical color assignment.",
   colorSub)
# Note that the HTML table is rendered in 'Rmarkdown', not pkgdown
kbl

# return_type="data.frame" is a data.frame with HTML contents
kdf3 <- kable_coloring(
   return_type="data.frame",
   df=expt_df,
   colorSub=colorSub)
kdf3;
\dontshow{\}) # examplesIf}
}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}

Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam color functions}
\concept{jam practical functions}
