% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plotridges.R
\name{plotRidges}
\alias{plotRidges}
\title{Plot ridges density plots for numeric matrix input}
\usage{
plotRidges(
  x,
  xScale = c("none", "-log10", "log10"),
  xlab = NULL,
  ylab = NULL,
  title = ggplot2::waiver(),
  subtitle = ggplot2::waiver(),
  caption = ggplot2::waiver(),
  xlim = NULL,
  color_sub = NULL,
  rel_min_height = 0,
  bandwidth = NULL,
  adjust = 1,
  scale = 1,
  share_bandwidth = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{matrix} with numeric values, or a \code{list} of \code{numeric}
vectors. In either case the data is converted to long-tall
format before plotting.}

\item{xScale}{\code{character} string indicating whether to transform
the x-axis values:
\itemize{
\item \code{"none"}: no transformation
\item \code{"-log10"}: values are transformed with \code{log10(x)} and x-axis
labels are adjusted accordingly.
\item \code{"log10"}: values are transformed with \code{log10(1 + x)} except
that negative values are transformed with \code{-log10(1 - x)}. The
x-axis labels are plotted to account for the \code{log10(1 + x)} offset.
}}

\item{xlab, ylab}{\code{character} strings optionally used as x-axis and y-axis
labels.}

\item{title, subtitle, caption}{\code{character} string values optionally passed
to the relevant downstream \code{ggplot2} functions.}

\item{xlim}{passed to \code{ggplot2::xlim()} to define the x-axis range.}

\item{color_sub}{\code{character} vector named by \code{colnames(x)}, or when
\code{x} is a \code{list}, \code{names(color_sub)} should contain \code{names(x)}, used
to define specific colors for each ridge plot.}

\item{rel_min_height}{\code{numeric} values passed to
\code{ggridges::geom_density_ridges2()}}

\item{bandwidth}{\code{numeric} value used to define the bandwidth density
when \code{share_bandwidth=TRUE} which is default. The bandwidth
affects the level of detail presented in each ridgeline, and when
shared across ridgelines \code{share_bandwidth=TRUE} then each ridgeline
will use the same consistent level of detail. In this case, it
is passed to \code{ggridges::geom_density_ridges2()}.
Note when \code{bandwidth=NULL} a default value is derived from the
range of data to be plotted.}

\item{adjust}{\code{numeric} used to adjust the default bandwidth only
when \code{bandwidth=NULL}. It is intended as a convenient method to
adjust the level of detail.}

\item{scale}{\code{numeric} passed directly to
\code{ggridges::geom_density_ridges2()}.}

\item{share_bandwidth}{\code{logical} indicating whether to supply
\code{ggridges::geom_density_ridges2()} a specific \code{bandwidth} to use
for all ridgelines. When \code{share_bandwidth=FALSE} then each ridgeline
is presented using the default bandwidth in
\code{ggridges::geom_density_ridges2()}.}

\item{...}{additional arguments are ignored.}
}
\value{
object with class \verb{"gg", "ggplot"} with density plot
in the form of ridges.
}
\description{
Plot ridges density plots for numeric matrix input
}
\details{
This function is a convenient wrapper for \code{ggridges::geom_density_ridges2()},
intended to be analogous to \code{plotPolygonDensity()} which differs
by plotting each item in a separate plot panel using base graphics.
This function plots each item as a ridgeline plot in the same
plot window using \code{ggplot2::ggplot()}.
}
\examples{
\dontshow{if ((requireNamespace("ggridges", quietly=TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# multiple columns
set.seed(123);
xm <- do.call(cbind, lapply(1:4, function(i){stats::rnorm(2000)}))
plotRidges(xm)

set.seed(123);
x <- stats::rnorm(2000)
plotRidges(x)
\dontshow{\}) # examplesIf}
}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
