% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-export.r
\name{set_xlsx_rowheights}
\alias{set_xlsx_rowheights}
\title{Set row heights in Xlsx files}
\usage{
set_xlsx_rowheights(
  xlsxFile,
  sheet = 1,
  rows = seq_along(heights) + 1,
  heights = 17,
  ...
)
}
\arguments{
\item{xlsxFile}{\code{character} filename to a file with ".xlsx" extension,
or \code{Workbook} object defined in the \code{openxlsx} package. When
\code{xlsxFile} is a \code{Workbook} the output is not saved to a file.}

\item{sheet}{\code{integer} sheet number or \code{character} sheet name,
passed to \code{openxlsx::setRowHeights()} indicating
the worksheet to affect.}

\item{rows}{\verb{integer vector} indicating the row numbers to affect.}

\item{heights}{\verb{numeric vector} indicating the height of each column
defined by \code{rows}.}

\item{...}{additional arguments are passed to \code{openxlsx::setRowHeights()}.}
}
\value{
\code{Workbook} object as defined by the \code{openxlsx} package
is returned invisibly with \code{invisible()}. This \code{Workbook}
can be used in argument \code{wb} to provide a speed boost when
saving multiple sheets to the same file.
}
\description{
This function is a light wrapper to perform these steps
from the very useful \code{openxlsx} R package:
}
\details{
\itemize{
\item \code{openxlsx::loadWorkbook()}
\item \code{openxlsx::setRowHeights()}
\item \code{openxlsx::saveWorkbook()}
}

Note that when only the argument \code{heights} is defined,
the argument \code{rows} will point to row 2 and lower, thus
skipping the first (header) row. Define \code{rows} specifically
in order to affect the header row as well.
}
\examples{
# write to tempfile for examples
if (check_pkg_installed("openxlsx")) {
   out_xlsx <- tempfile(pattern="writeOpenxlsx_", fileext=".xlsx")
   df <- data.frame(a=LETTERS[1:5], b=1:5);
   writeOpenxlsx(x=df,
      file=out_xlsx,
      sheetName="jamba_test");

   ## by default, rows will start at row 2, skipping the header
   set_xlsx_rowheights(out_xlsx,
      sheet="jamba_test",
      heights=rep(17, nrow(df))
   )

   ## to include the header row
   set_xlsx_rowheights(out_xlsx,
      sheet="jamba_test",
      rows=seq_len(nrow(df)+1),
      heights=rep(17, nrow(df)+1)
   )
}

}
\seealso{
Other jam export functions: 
\code{\link{applyXlsxCategoricalFormat}()},
\code{\link{applyXlsxConditionalFormat}()},
\code{\link{readOpenxlsx}()},
\code{\link{set_xlsx_colwidths}()},
\code{\link{writeOpenxlsx}()}
}
\concept{jam export functions}
