% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-size.R
\name{sizeAsNum}
\alias{sizeAsNum}
\title{convert size to numeric value}
\usage{
sizeAsNum(x, kiloSize = 1024, verbose = FALSE, ...)
}
\arguments{
\item{x}{\code{character} vector. When \code{x} is numeric, it is returned as-is;
otherwise x is coerced to \code{character} with \code{as.character()} and
will throw an error if it fails.}

\item{kiloSize}{\code{numeric} number of base units when converting from one
base unit, to one "kilo" base unit. For file sizes, this value is 1024,
but for other purposes this value may be 1000, like one thousand units
is \code{"1k units"}.}

\item{verbose}{\code{logical} indicating whether to print verbose output.
The output includes a \code{data.frame} summarizing the input,
and the unit matched, and the final value. If \code{verbose==2} it
will return this \code{data.frame} for review.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{numeric} vector representing the numeric value represented
by an abbreviated size.
}
\description{
convert size to numeric value
}
\details{
This function is intended to provide the inverse of \code{asSize()}
by converting an abbreviated size into a full numeric value.

It makes one simplifying assumption, that the first character in
the unit is enough to determine the unit. This assumption also means
the units are currently case-sensitive, for example \code{Mega} requires
upper-case \code{"M"}, because \code{"milli"} which is not supported,
requires \code{"m"}.

Unit abbreviations recognized:
\itemize{
\item \code{k} - kilo - size is defined by \code{kiloSize}
\item \code{M} - Mega - size is defined by \code{kiloSize ^ 2}
\item \code{G} - Giga - size is defined by \code{kiloSize ^ 3}
\item \code{T} - Tera - size is defined by \code{kiloSize ^ 4}
\item \code{P} - Peta - size is defined by \code{kiloSize ^ 5}
}

Everything else is considered to have no abbreviated units, thus
the numeric value is returned as-is.

Note that the round trip \code{asSize()} followed by \code{sizeAsNum()} will
not produce identical values, because the intermediate value is
rounded by \code{digits} in \code{asSize()}.
}
\examples{
x <- asSize(c(1, 10,2010,22000,52200), unitType="")
x
#> "1"   "10" "2k"     "21k"    "51k"
sizeAsNum(x)

sizeAsNum(x, kiloSize=1000)

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
