% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{fisher.test}
\alias{fisher.test}
\alias{fisher.test.default}
\alias{fisher.test.tabyl}
\title{Apply stats::fisher.test to a two-way tabyl}
\usage{
fisher.test(x, ...)

\method{fisher.test}{default}(x, y = NULL, ...)

\method{fisher.test}{tabyl}(x, ...)
}
\arguments{
\item{x}{a two-way tabyl, a numeric vector or a factor}

\item{...}{other parameters passed to stats::fisher.test}

\item{y}{if x is a vector, must be another vector or factor of the same length}
}
\value{
The result is the same as the one of stats::fisher.test.
}
\description{
This generic function overrides stats::fisher.test. If the passed table 
is a two-way tabyl, it runs it through janitor::fisher.test.tabyl, otherwise
it just calls stats::fisher.test.
}
\examples{
tab <- tabyl(mtcars, gear, cyl)
fisher.test(tab)

}
