\name{net.hubs}
\alias{net.hubs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Get degrees of the most connected nodes of each graph in the input list of multiple graphs.
}
\description{
List the degrees of the hub nodes of each graph in the input list of multiple graphs.
}
\usage{
net.hubs(theta, nhubs = 10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{theta}{
  An input list of multiple graphs. Each graph is represented as a pXp matrix. (For example, the result of the SIMULE algorithm: a list of pXp matrices in which each matrix represents an estimated sparse inverse covariance matrix.)
}
  \item{nhubs}{
The number of hubs to be identified of each graph in the input list of multiple graphs.
}
}

\value{
hubs, a length K list. Each element in this list is a vector of length nhubs whose entries give the degree of the most connected nodes of each graph in the input list of multiple graphs.}
\references{
Beilun Wang, Arshdeep Sekhon, Yanjun Qi. A Fast and Scalable Joint Estimator for Integrating Additional Knowledge in Learning Multiple Related Sparse Gaussian Graphical Models. ICML 2018
}
\author{
Beilun Wang}
\examples{
data(cancer)
X = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"),]),
as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"),]))
##run jeek
result = jeek(X, 0.05, covType = "cov", parallel = FALSE)
## get hubs list:
net.hubs(result$Graphs)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
