% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluatePerformance.R
\name{evaluatePerformance}
\alias{evaluatePerformance}
\title{Evaluation of graph estimation method's performance if the true graph is known.}
\usage{
evaluatePerformance(G, G_hat)
}
\arguments{
\item{G}{true graph's adjacency matrix.}

\item{G_hat}{estimated graph's adjacency matrix. Must have the same dimensions as \code{G}.}
}
\value{
performance - a numeric vector of length 4 with TP, TN, FP, FN.
}
\description{
Function compares adjacency matrices of the true and estimated simple graphs and calculates the number of true positives (correctly estimated edges), true negatives (correctly estimated absence of edges), false positives (edges present in the estimator but not in the true graph) and false negatives (failure to identify an edge).
}
\examples{
{
K <- 3
p <- 50
n <- 20
data <- generateData_rewire(K = K, p = p, n = n, ncores = 1, verbose = FALSE)
G_common_true <- data$CommonGraph
X <- data$Data
res <- jewel(X, lambda1 = 0.25)
G_common_est <- res$CommonG
evaluatePerformance(G = G_common_true, G_hat = G_common_est)
}
}
