% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoTriangle.R
\name{annoTriangle}
\alias{annoTriangle}
\title{annoTriangle}
\usage{
annoTriangle(
  object = NULL,
  relSideDist = 0.1,
  annoPos = "top",
  xPosition = NULL,
  yPosition = NULL,
  fillCol = NULL,
  nCol = 100,
  addTriangle = TRUE,
  triangleType = "RD",
  addBorder = FALSE,
  borderCol = "black",
  lty = NULL,
  lwd = NULL,
  myFacetGrou = NULL,
  aes_x = NULL,
  aes_y = NULL
)
}
\arguments{
\item{object}{Your ggplot list. Default(NULL).}

\item{relSideDist}{The relative distance ratio to the y axis range. Default(0.1).}

\item{annoPos}{The position for the annotation to be added. Default("top").}

\item{xPosition}{The x axis coordinate for the triangle. Default(NULL).}

\item{yPosition}{The y axis coordinate for the triangle. Default(NULL).}

\item{fillCol}{The triangle fill colors. Default(NULL).}

\item{nCol}{The colors bins. Default(100).}

\item{addTriangle}{Whether add triangle annotation. Default("TRUE").}

\item{triangleType}{The triangle shape type, "RU"(right-up), "RD"(right-down), "LU"(left-up), "LD"(left-down). Default("RD").}

\item{addBorder}{Whether add border to triangle or rect annotation. Default("FALSE").}

\item{borderCol}{The border color. Default("black").}

\item{lty}{The border lty. Default(NULL).}

\item{lwd}{The border lwd. Default(NULL).}

\item{myFacetGrou}{Your facet group name to be added with annotation when object is a faceted object. Default(NULL).}

\item{aes_x}{= NULL You should supply the plot X mapping name when annotate a facetd plot. Default(NULL).}

\item{aes_y}{= NULL You should supply the plot Y mapping name when annotate a facetd plot. Default(NULL).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add triangle annotations in plot.
}
\examples{
\donttest{# ===============================
# test function

# load test data
data(p)

p1 <- p +
 ggplot2::theme(plot.margin = ggplot2::margin(t = 2,unit = 'cm'))

# default plot
annoTriangle(object = p1,
            annoPos = 'top',
            xPosition = c(0,10.5))

# ajust yposition
annoTriangle(object = p1,
            annoPos = 'top',
            xPosition = c(0.5,10.5),
            yPosition = c(10.8,11.5))

# add border
annoTriangle(object = p1,
            annoPos = 'top',
            xPosition = c(0.5,10.5),
            yPosition = c(10.8,11.5),
            addBorder = TRUE,
            lwd = 2.5)
}
}
\author{
Junjun Lao
}
