% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{postSurvfit}
\alias{postSurvfit}
\title{postSurvfit}
\usage{
postSurvfit(model, ids, ...)
}
\arguments{
\item{model}{fitted model}

\item{ids}{value of id}

\item{...}{other parameter option, see \code{posterior_survfit}}
}
\value{
list of predicted value for the given id
}
\description{
posterior survival probability estimates from rstanarm for BIG data
}
\examples{
 \donttest{
##
library(survival)
library(dplyr)
jmstan<-jmstanBig(dtlong=long2,
         dtsurv = surv2,
         longm=y~ x7+visit+(1|id),
         survm=Surv(time,status)~x1+visit,
         samplesize=200,
         time_var='visit',id='id')
mod1<-jmstan
P2<-postSurvfit(model<-mod1,ids<-c(1,2,210))
pp1<-plot(P2$p1[[1]])
pp1
pp2<-plot(P2$p1[[2]])
pp2
pp3<-plot(P2$p1[[3]])
pp3
 ##
   }
}
