% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglinear.h.R
\name{logLinear}
\alias{logLinear}
\title{Log-Linear Regression}
\usage{
logLinear(data, factors = NULL, counts = NULL, blocks = list(list()),
  refLevels = NULL, modelTest = FALSE, dev = TRUE, aic = TRUE,
  bic = FALSE, pseudoR2 = list("r2mf"), omni = FALSE, ci = FALSE,
  ciWidth = 95, RR = FALSE, ciRR = FALSE, ciWidthRR = 95,
  emMeans = list(list()), ciEmm = TRUE, ciWidthEmm = 95,
  emmPlots = TRUE, emmTables = FALSE, emmWeights = TRUE)
}
\arguments{
\item{data}{the data as a data frame}

\item{factors}{a vector of strings naming the factors from \code{data}}

\item{counts}{a string naming a variable in \code{data} containing counts,
or NULL if each row represents a single observation}

\item{blocks}{a list containing vectors of strings that name the predictors
that are added to the model. The elements are added to the model according
to their order in the list}

\item{refLevels}{a list of lists specifying reference levels of the
dependent variable and all the factors}

\item{modelTest}{\code{TRUE} or \code{FALSE} (default), provide the model
comparison between the models and the NULL model}

\item{dev}{\code{TRUE} (default) or \code{FALSE}, provide the deviance (or
-2LogLikelihood) for the models}

\item{aic}{\code{TRUE} (default) or \code{FALSE}, provide Aikaike's
Information Criterion (AIC) for the models}

\item{bic}{\code{TRUE} or \code{FALSE} (default), provide Bayesian
Information Criterion (BIC) for the models}

\item{pseudoR2}{one or more of \code{'r2mf'}, \code{'r2cs'}, or
\code{'r2n'}; use McFadden's, Cox & Snell, and Nagelkerke pseudo-R²,
respectively}

\item{omni}{\code{TRUE} or \code{FALSE} (default), provide the omnibus
likelihood ratio tests for the predictors}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}

\item{RR}{\code{TRUE} or \code{FALSE} (default), provide the exponential of
the log-rate ratio estimate, or the rate ratio estimate}

\item{ciRR}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient rate ratio estimates}

\item{ciWidthRR}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}

\item{emMeans}{a list of lists specifying the variables for which the
estimated marginal means need to be calculate. Supports up to three
variables per term.}

\item{ciEmm}{\code{TRUE} (default) or \code{FALSE}, provide a confidence
interval for the estimated marginal means}

\item{ciWidthEmm}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width for the estimated marginal means}

\item{emmPlots}{\code{TRUE} (default) or \code{FALSE}, provide estimated
marginal means plots}

\item{emmTables}{\code{TRUE} or \code{FALSE} (default), provide estimated
marginal means tables}

\item{emmWeights}{\code{TRUE} (default) or \code{FALSE}, weigh each cell
equally or weigh them according to the cell frequency}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$modelFit} \tab \tab \tab \tab \tab a table \cr
  \code{results$modelComp} \tab \tab \tab \tab \tab a table \cr
  \code{results$models} \tab \tab \tab \tab \tab an array of model specific results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$modelFit$asDF}

\code{as.data.frame(results$modelFit)}
}
\description{
Log-Linear Regression
}
\examples{
data('mtcars')

tab <- table('gear'=mtcars$gear, 'cyl'=mtcars$cyl)
dat <- as.data.frame(tab)

logLinear(data = dat, factors = c("gear", "cyl"),  counts = "Freq",
          blocks = list(list("gear", "cyl", c("gear", "cyl"))),
          refLevels = list(
              list(var="gear", ref="3"),
              list(var="cyl", ref="4")))

#
#  LOG-LINEAR REGRESSION
#
#  Model Fit Measures
#  ---------------------------------------
#    Model    Deviance    AIC     R²-McF
#  ---------------------------------------
#        1    4.12e-10    41.4     1.000
#  ---------------------------------------
#
#
#  MODEL SPECIFIC RESULTS
#
#  MODEL 1
#
#  Model Coefficients
#  ------------------------------------------------------------------
#    Predictor          Estimate     SE          Z            p
#  ------------------------------------------------------------------
#    Intercept          -4.71e-16        1.00    -4.71e-16    1.000
#    gear:
#    4 – 3                  2.079        1.06        1.961    0.050
#    5 – 3                  0.693        1.22        0.566    0.571
#    cyl:
#    6 – 4                  0.693        1.22        0.566    0.571
#    8 – 4                  2.485        1.04        2.387    0.017
#    gear:cyl:
#    (4 – 3):(6 – 4)       -1.386        1.37       -1.012    0.311
#    (5 – 3):(6 – 4)       -1.386        1.73       -0.800    0.423
#    (4 – 3):(8 – 4)      -26.867    42247.17    -6.36e -4    0.999
#    (5 – 3):(8 – 4)       -2.485        1.44       -1.722    0.085
#  ------------------------------------------------------------------
#
#

}
