% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efa.h.R
\name{efa}
\alias{efa}
\title{Exploratory Factor Analysis}
\usage{
efa(data, vars, nFactorMethod = "parallel", nFactors = 1,
  minEigen = 0, extraction = "minres", rotation = "oblimin",
  hideLoadings = 0.3, sortLoadings = FALSE, screePlot = FALSE,
  eigen = FALSE, factorCor = FALSE, factorSummary = FALSE,
  modelFit = FALSE, kmo = FALSE, bartlett = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in
\code{data}}

\item{nFactorMethod}{\code{'parallel'} (default), \code{'eigen'} or
\code{'fixed'}, the way to determine the number of factors}

\item{nFactors}{an integer (default: 1), the number of factors in the model}

\item{minEigen}{a number (default: 0), the minimal eigenvalue for a factor
to be included in the model}

\item{extraction}{\code{'minres'} (default), \code{'ml'}, or \code{'pa'}
use respectively 'minimum residual', 'maximum likelihood', or 'prinicipal
axis' as the factor extraction method}

\item{rotation}{\code{'none'}, \code{'varimax'}, \code{'quartimax'},
\code{'promax'}, \code{'oblimin'} (default), or \code{'simplimax'}, the
rotation to use in estimation}

\item{hideLoadings}{a number (default: 0.3), hide factor loadings below
this value}

\item{sortLoadings}{\code{TRUE} or \code{FALSE} (default), sort the factor
loadings by size}

\item{screePlot}{\code{TRUE} or \code{FALSE} (default), show scree plot}

\item{eigen}{\code{TRUE} or \code{FALSE} (default), show eigenvalue table}

\item{factorCor}{\code{TRUE} or \code{FALSE} (default), show factor
correlations}

\item{factorSummary}{\code{TRUE} or \code{FALSE} (default), show factor
summary}

\item{modelFit}{\code{TRUE} or \code{FALSE} (default), show model fit
measures and test}

\item{kmo}{\code{TRUE} or \code{FALSE} (default), show Kaiser-Meyer-Olkin
(KMO) measure of sampling adequacy (MSA) results}

\item{bartlett}{\code{TRUE} or \code{FALSE} (default), show Bartlett's test
of sphericity results}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
}
}
\description{
Exploratory Factor Analysis
}
\examples{
data('iris')

efa(iris, vars = vars(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width))

#
#  EXPLORATORY FACTOR ANALYSIS
#
#  Factor Loadings
#  ------------------------------------------------
#                    1        2        Uniqueness
#  ------------------------------------------------
#    Sepal.Length    0.993                0.10181
#    Sepal.Width              0.725       0.42199
#    Petal.Length    0.933                0.00483
#    Petal.Width     0.897                0.07088
#  ------------------------------------------------
#    Note. 'oblimin' rotation was used
#

}
