% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ranef.mjoint.R
\name{plot.ranef.mjoint}
\alias{plot.ranef.mjoint}
\title{Plot a \code{ranef.mjoint} object}
\usage{
\method{plot}{ranef.mjoint}(x, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{ranef.mjoint}, representing
the estimated random effects for the \code{mjoint} object from which it was
produced.}

\item{...}{additional arguments; currently none are used.}
}
\value{
an object inheriting from class \code{ggplot}, which displays a
  trellis plot with a separate panel for each effect, showing a dotplot (with
  optional error bars indicating approximate 95\% prediction intervals if the
  argument \code{postVar = TRUE} is set in the call to \code{\link{ranef}})
  for each subject (by row).
}
\description{
Displays a plot of the BLUPs and approximate 95\% prediction
  interval for each subject.
}
\examples{
\dontrun{
require(ggplot2)
data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]
set.seed(1)

fit1 <- mjoint(formLongFixed = log.lvmi ~ time,
    formLongRandom = ~ time | num,
    formSurv = Surv(fuyrs, status) ~ 1,
    data = hvd,
    timeVar = "time")

plot(ranef(fit1, postVar = TRUE))
}
}
\references{
Pinheiro JC, Bates DM. \emph{Mixed-Effects Models in S and S-PLUS.} New York:
Springer Verlag; 2000.
}
\seealso{
\code{\link{ranef.mjoint}}.
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{methods}
