% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_display.R
\name{joyn_report}
\alias{joyn_report}
\title{Print JOYn report table}
\usage{
joyn_report(verbose = getOption("joyn.verbose"))
}
\arguments{
\item{verbose}{logical: if FALSE, it won't display any message (programmer's
option). Default is TRUE.}
}
\value{
invisible table of frequencies
}
\description{
Print JOYn report table
}
\examples{
library(data.table)
x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
t  = c(1L, 2L, 1L, 2L, NA_integer_),
x  = 11:15)

y1 = data.table(id = 1:2,
                y  = c(11L, 15L))

d <- joyn(x1, y1, match_type = "m:1")
joyn_report(verbose = TRUE)
}
\seealso{
Messages functions
\code{\link{clear_joynenv}()},
\code{\link{joyn_msg}()},
\code{\link{joyn_msgs_exist}()},
\code{\link{msg_type_dt}()},
\code{\link{store_msg}()},
\code{\link{style}()},
\code{\link{type_choices}()}
}
\concept{messages}
