% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurse.R
\name{recurse}
\alias{recurse}
\alias{recurse_}
\title{Search through a recursive structure - extract data from all levels}
\usage{
recurse(.data, ...)

recurse_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Search through a recursive structure - extract data from all levels
}
\examples{
x <- '{"name": "/", "children": [
  {"name": "/bin", "children": [
    {"name": "/bin/ls", "children": []},
    {"name": "/bin/sh", "children": []}]},
  {"name": "/home", "children": [
    {"name": "/home/stephen", "children": [
      {"name": "/home/stephen/jq", "children": []}]}]}]}'
x \%>\% recurse(.children[]) \%>\% select(name)
x \%>\% recurse(.children[]) \%>\% select(name) \%>\% string
}

