% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxme.R
\name{extractAIC.coxme}
\alias{extractAIC.coxme}
\title{extractAIC.coxme: Extract AIC from coxme.object}
\usage{
\method{extractAIC}{coxme}(fit, scale = NULL, k = 2, ...)
}
\arguments{
\item{fit}{coxme.object}

\item{scale}{NULL}

\item{k}{numeric specifying the 'weight' of the equivalent degrees of freedom (=: edf) part in the AIC formula.}

\item{...}{further arguments (currently unused in base R).}
}
\value{
AIC(Integreted, Penalized)
}
\description{
Extract AIC from coxme.object
}
\details{
DETAILS
}
\examples{
 library(coxme)
 fit <- coxme(Surv(time, status) ~ ph.ecog + age + (1|inst), lung)
 extractAIC(fit)
}
