% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestcox.R
\name{TableSubgroupMultiCox}
\alias{TableSubgroupMultiCox}
\title{TableSubgroupMultiCox: Multiple sub-group analysis table for Cox/svycox model.}
\usage{
TableSubgroupMultiCox(
  formula,
  var_subgroups = NULL,
  var_cov = NULL,
  data,
  time_eventrate = 3 * 365,
  decimal.hr = 2,
  decimal.percent = 1,
  decimal.pvalue = 3,
  line = F,
  cluster = NULL,
  strata = NULL,
  weights = NULL
)
}
\arguments{
\item{formula}{formula with survival analysis.}

\item{var_subgroups}{Multiple sub-group variables for analysis, Default: NULL}

\item{var_cov}{Variables for additional adjust, Default: NULL}

\item{data}{Data or svydesign in survey package.}

\item{time_eventrate}{Time for kaplan-meier based event rate calculation, Default = 365 * 3}

\item{decimal.hr}{Decimal for hazard ratio, Default: 2}

\item{decimal.percent}{Decimal for percent, Default: 1}

\item{decimal.pvalue}{Decimal for pvalue, Default: 3}

\item{line}{Include new-line between sub-group variables, Default: F}

\item{cluster}{Cluster variable for coxph, Default: NULL}

\item{strata}{Strata variable for coxph, Default: NULL}

\item{weights}{Weights variable for coxph, Default: NULL}
}
\value{
Multiple sub-group analysis table.
}
\description{
Multiple sub-group analysis table for Cox/svycox model.
}
\details{
This result is used to make forestplot.
}
\examples{
library(survival)
library(dplyr)
lung \%>\%
  mutate(
    status = as.integer(status == 1),
    sex = factor(sex),
    kk = factor(as.integer(pat.karno >= 70)),
    kk1 = factor(as.integer(pat.karno >= 60))
  ) -> lung
TableSubgroupMultiCox(Surv(time, status) ~ sex,
  var_subgroups = c("kk", "kk1"),
  data = lung, time_eventrate = 100, line = TRUE
)

## survey design
library(survey)
data.design <- svydesign(id = ~1, data = lung)
TableSubgroupMultiCox(Surv(time, status) ~ sex,
  var_subgroups = c("kk", "kk1"),
  data = data.design, time_eventrate = 100
)
}
\seealso{
\code{\link[purrr]{map}}
 \code{\link[dplyr]{bind}}
}
