% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood_diploid.R
\name{log_likelihood_diploid}
\alias{log_likelihood_diploid}
\title{calculate the log likelihood of observing diploid ancestry data.}
\usage{
log_likelihood_diploid(
  local_anc_matrix,
  pop_size,
  freq_ancestor_1 = 0.5,
  t,
  phased = FALSE,
  num_threads = 1
)
}
\arguments{
\item{local_anc_matrix}{a matrix with four columns: column 1) chromosome
indicator, 2) location of marker in Morgan on respective chromosome 3)
ancestry at chromosome 4) ancestry at chromosome 2.}

\item{pop_size}{population size}

\item{freq_ancestor_1}{Frequency of ancestor 1 at t = 0}

\item{t}{time since admixture}

\item{phased}{is the data phased or not? default is false.}

\item{num_threads}{number of threads, default is one thread. Set to -1 to
use all available threads.}
}
\value{
log likelihood
}
\description{
Calculates the log likelihood of observing the phased data,
given the population size, initial heterozygosity and time since admixture
}
