% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriate_average.R,
%   R/seriate_permute.R, R/seriate_rank.R, R/seriate_resample.R
\docType{methods}
\name{seriation}
\alias{seriation}
\alias{seriate_average}
\alias{seriate_average-method}
\alias{seriate_rank}
\alias{seriate_rank-method}
\alias{refine}
\alias{refine-method}
\alias{permute}
\alias{permute-method}
\alias{get_order}
\alias{get_order-method}
\alias{seriate_average,data.frame-method}
\alias{seriate_average,matrix-method}
\alias{permute,data.frame,PermutationOrder-method}
\alias{permute,matrix,PermutationOrder-method}
\alias{get_order,PermutationOrder-method}
\alias{seriate_rank,data.frame-method}
\alias{seriate_rank,matrix-method}
\alias{refine,AveragePermutationOrder-method}
\alias{refine,CA-method}
\alias{refine,BootstrapCA-method}
\title{Matrix Seriation}
\usage{
seriate_average(object, ...)

seriate_rank(object, ...)

refine(object, ...)

permute(object, order, ...)

get_order(x, ...)

\S4method{seriate_average}{data.frame}(object, margin = c(1, 2), axes = 1, ...)

\S4method{seriate_average}{matrix}(object, margin = c(1, 2), axes = 1, ...)

\S4method{permute}{data.frame,PermutationOrder}(object, order)

\S4method{permute}{matrix,PermutationOrder}(object, order)

\S4method{get_order}{PermutationOrder}(x, margin = c(1, 2))

\S4method{seriate_rank}{data.frame}(object, EPPM = FALSE, margin = c(1, 2), stop = 100)

\S4method{seriate_rank}{matrix}(object, EPPM = FALSE, margin = c(1, 2), stop = 100)

\S4method{refine}{AveragePermutationOrder}(object, cutoff, margin = c(1, 2), axes = c(1, 2), n = 30)

\S4method{refine}{BootstrapCA}(object, cutoff, margin = 1, axes = c(1, 2))
}
\arguments{
\item{object, x}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{...}{Further arguments to be passed to internal methods.}

\item{order}{A \linkS4class{PermutationOrder} object giving the permutation
order for rows and columns.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows then columns, \code{c(2, 1)} indicates columns
then rows.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA axes to be
used.}

\item{EPPM}{A \code{\link{logical}} scalar: should the seriation be computed on EPPM
instead of raw data?}

\item{stop}{An \code{\link{integer}} giving the stopping rule (i.e. maximum number of
iterations) to avoid infinite loop.}

\item{cutoff}{A function that takes a numeric vector as argument and returns
a single numeric value (see below).}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
\itemize{
\item \verb{seriate_*()} returns a \linkS4class{PermutationOrder} object.
\item \code{permute()} returns either a permuted \code{matrix} or a permuted \code{data.frame}
(the same as \code{object}).
\item \code{bootstrap()} returns a \linkS4class{RefineCA} object.
}
}
\description{
\itemize{
\item \verb{seriate_*()} computes a permutation order for rows and/or columns.
\item \code{permute()} rearranges a data matrix according to a permutation order.
\item \code{get_order()} returns the seriation order for rows and columns.
}
}
\section{Seriation}{

The matrix seriation problem in archaeology is based on three conditions
and two assumptions, which Dunell (1970) summarizes as follows.

The homogeneity conditions state that all the groups included in a
seriation must:
\enumerate{
\item{Be of comparable duration.}
\item{Belong to the same cultural tradition.}
\item{Come from the same local area.}
}

The mathematical assumptions state that the distribution of any historical
or temporal class:
\enumerate{
\item{Is continuous through time.}
\item{Exhibits the form of a unimodal curve.}
}
Theses assumptions create a distributional model and ordering is
accomplished by arranging the matrix so that the class distributions
approximate the required pattern. The resulting order is inferred
to be chronological.

The following seriation methods are available:
\describe{
\item{\code{seriate_average()}}{Correspondence analysis-based seriation
(average ranking). Correspondence analysis (CA) is an effective method for
the seriation of archaeological assemblages. The order of the rows and
columns is given by the coordinates along one dimension of the CA space,
assumed to account for temporal variation. The direction of temporal change
within the correspondence analysis space is arbitrary: additional
information is needed to determine the actual order in time.}
\item{\code{seriate_rank()}}{Reciprocal ranking seriation. These procedures
iteratively rearrange rows and/or columns according to their weighted rank
in the data matrix until convergence.
Note that this procedure could enter into an infinite loop.
If no convergence is reached before the maximum number of iterations, it
stops with a warning.}
}
}

\section{Correspondence Analysis}{

\code{bootstrap()} allows to identify samples that are subject to
sampling error or samples that have underlying structural relationships
and might be influencing the ordering along the CA space.

This relies on a partial bootstrap approach to CA-based seriation where each
sample is replicated \code{n} times. The maximum dimension length of
the convex hull around the sample point cloud allows to remove samples for
a given \code{cutoff} value.

According to Peebles and Schachner (2012), "[this] point removal procedure
[results in] a reduced dataset where the position of individuals within the
CA are highly stable and which produces an ordering consistent with the
assumptions of frequency seriation."
}

\examples{
## Replicates Desachy 2004 results
## Coerce dataset to abundance matrix
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
get_order(indices, 1) # rows
get_order(indices, 2) # columns

## Permute columns
(new <- permute(compiegne, indices))

## See the vignette
\dontrun{
utils::vignette("seriation")
}
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.

Dunnell, R. C. (1970). Seriation Method and Its Evaluation. \emph{American
Antiquity}, 35(03), 305-319. \doi{10.2307/278341}.

Ihm, P. (2005). A Contribution to the History of Seriation in Archaeology.
In C. Weihs & W. Gaul (Eds.), \emph{Classification: The Ubiquitous
Challenge}. Berlin Heidelberg: Springer, p. 307-316.
\doi{10.1007/3-540-28084-7_34}.

Peeples, M. A., & Schachner, G. (2012). Refining correspondence
analysis-based ceramic seriation of regional data sets. \emph{Journal of
Archaeological Science}, 39(8), 2818-2827.
\doi{10.1016/j.jas.2012.04.040}.
}
\seealso{
\code{\link[dimensio:ca]{dimensio::ca()}}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
