% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaya.R
\name{get_top_down_trends}
\alias{get_top_down_trends}
\title{Get top-down trends for Kaya variables for a country or region, using
projections from U.S. Energy Information Administration's International
Energy Outlook report.}
\usage{
get_top_down_trends(region_name, quiet = FALSE, region_code = NULL)
}
\arguments{
\item{region_name}{The name of a country or region to look up}

\item{quiet}{Suppress warnings if there is no data for that country or
region.}

\item{region_code}{Optional three-letter country or region code to look up
instead of the `region_name`}
}
\value{
a tibble of trends for P, G, E, F, g, e, f, and ef for the country,
or region in percent per year.
}
\description{
Get top-down trends for Kaya variables for a country or region, using
projections from U.S. Energy Information Administration's International
Energy Outlook report.
}
\examples{
get_top_down_trends("Spain")
get_top_down_trends(region_code = "RUS")
}
