% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdtools.R
\name{kd_nearest_neighbors}
\alias{kd_nearest_neighbors}
\alias{kd_nearest_neighbors.matrix}
\alias{kd_nearest_neighbors.arrayvec}
\alias{kd_nearest_neighbors.data.frame}
\alias{kd_nn_indices}
\alias{kd_nn_indices.matrix}
\alias{kd_nn_indices.arrayvec}
\alias{kd_nn_indices.data.frame}
\alias{kd_nearest_neighbor}
\alias{kd_nearest_neighbor.matrix}
\alias{kd_nearest_neighbor.arrayvec}
\title{Find nearest neighbors}
\usage{
kd_nearest_neighbors(x, v, n, ...)

\method{kd_nearest_neighbors}{matrix}(x, v, n, ...)

\method{kd_nearest_neighbors}{arrayvec}(x, v, n, ...)

\method{kd_nearest_neighbors}{data.frame}(x, v, n, cols = 1:ncol(x), w = rep(1, length(cols)), ...)

kd_nn_indices(x, v, n, ...)

\method{kd_nn_indices}{matrix}(x, v, n, ...)

\method{kd_nn_indices}{arrayvec}(x, v, n, ...)

\method{kd_nn_indices}{data.frame}(x, v, n, cols = 1:ncol(x), w = rep(1, length(cols)), ...)

kd_nearest_neighbor(x, v)

\method{kd_nearest_neighbor}{matrix}(x, v)

\method{kd_nearest_neighbor}{arrayvec}(x, v)
}
\arguments{
\item{x}{an object sorted by \code{\link{kd_sort}}}

\item{v}{a vector specifying where to look}

\item{n}{the number of neighbors to return}

\item{...}{additional arguments}

\item{cols}{integer indices of columns to use}

\item{w}{distance weights}
}
\value{
\tabular{ll}{
\code{kd_nearest_neighbors} \tab one or more rows from the sorted input \cr
\code{kd_nn_indices} \tab a vector of row indices indicating the result \cr
\code{kd_nearest_neighbor} \tab the row index of the neighbor \cr
}
}
\description{
Find nearest neighbors
}
\examples{
x = matrix(runif(200), 100)
y = matrix_to_tuples(x)
kd_sort(y, inplace = TRUE)
y[kd_nearest_neighbor(y, c(1/2, 1/2)),]
kd_nearest_neighbors(y, c(1/2, 1/2), 3)
y[kd_nn_indices(y, c(1/2, 1/2), 5),]

}
