% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_densenet}
\alias{application_densenet}
\alias{application_densenet121}
\alias{application_densenet169}
\alias{application_densenet201}
\alias{densenet_preprocess_input}
\title{Instantiates the DenseNet architecture.}
\usage{
application_densenet(
  blocks,
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

application_densenet121(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

application_densenet169(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

application_densenet201(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

densenet_preprocess_input(x, data_format = NULL)
}
\arguments{
\item{blocks}{numbers of building blocks for the four dense layers.}

\item{include_top}{whether to include the fully-connected layer at the top
of the network.}

\item{weights}{one of \code{NULL} (random initialization), 'imagenet'
(pre-training on ImageNet), or the path to the weights file to be loaded.}

\item{input_tensor}{optional Keras tensor (i.e. output of \code{layer_input()})
to use as image input for the model.}

\item{input_shape}{optional shape list, only to be specified if \code{include_top}
is FALSE (otherwise the input shape has to be \verb{(224, 224, 3)}
(with \code{channels_last} data format) or \verb{(3, 224, 224)} (with
\code{channels_first} data format). It should have exactly 3 inputs channels.}

\item{pooling}{optional pooling mode for feature extraction when
\code{include_top} is \code{FALSE}.
- \code{NULL} means that the output of the model will be the 4D tensor output
of the last convolutional layer.
- \code{avg} means that global average pooling will be applied to the output
of the last convolutional layer, and thus the output of the model
will be a 2D tensor.
- \code{max} means that global max pooling will be applied.}

\item{classes}{optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified.}

\item{x}{a 3D or 4D array consists of RGB values within \verb{[0, 255]}.}

\item{data_format}{data format of the image tensor.}
}
\description{
Instantiates the DenseNet architecture.
}
\details{
Optionally loads weights pre-trained
on ImageNet. Note that when using TensorFlow,
for best performance you should set
\code{image_data_format='channels_last'} in your Keras config
at ~/.keras/keras.json.

The model and the weights are compatible with
TensorFlow, Theano, and CNTK. The data format
convention used by the model is the one
specified in your Keras config file.
}
