% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_categorical_crossentropy}
\alias{metric_categorical_crossentropy}
\title{Computes the crossentropy metric between the labels and predictions.}
\usage{
metric_categorical_crossentropy(
  y_true,
  y_pred,
  from_logits = FALSE,
  label_smoothing = 0,
  axis = -1L,
  ...,
  name = "categorical_crossentropy",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor of one-hot true targets.}

\item{y_pred}{Tensor of predicted targets.}

\item{from_logits}{(Optional) Whether output is expected to be
a logits tensor. By default, we consider that output
encodes a probability distribution.}

\item{label_smoothing}{(Optional) Float in \verb{[0, 1]}.
When > 0, label values are smoothed, meaning the confidence
on label values are relaxed. e.g. \code{label_smoothing=0.2} means
that we will use a value of 0.1 for label
"0" and 0.9 for label "1".}

\item{axis}{(Optional) Defaults to \code{-1}.
The dimension along which entropy is computed.}

\item{...}{For forward/backward compatability.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
If \code{y_true} and \code{y_pred} are missing, a \code{Metric}
instance is returned. The \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage. If \code{y_true} and \code{y_pred} are provided, then a tensor with
the computed value is returned.
}
\description{
This is the crossentropy metric class to be used when there are multiple
label classes (2 or more). It assumes that labels are one-hot encoded,
e.g., when labels values are \code{c(2, 0, 1)}, then
\code{y_true} is \verb{rbind(c([0, 0, 1), c(1, 0, 0), c(0, 1, 0))}.
}
\section{Examples}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# EPSILON = 1e-7, y = y_true, y` = y_pred
# y` = clip_op_clip_by_value(output, EPSILON, 1. - EPSILON)
# y` = rbind(c(0.05, 0.95, EPSILON), c(0.1, 0.8, 0.1))
# xent = -sum(y * log(y'), axis = -1)
#      = -((log 0.95), (log 0.1))
#      = [0.051, 2.302]
# Reduced xent = (0.051 + 2.302) / 2
m <- metric_categorical_crossentropy()
m$update_state(rbind(c(0, 1, 0), c(0, 0, 1)),
               rbind(c(0.05, 0.95, 0), c(0.1, 0.8, 0.1)))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(1.1769392, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# 1.1769392
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$reset_state()
m$update_state(rbind(c(0, 1, 0), c(0, 0, 1)),
               rbind(c(0.05, 0.95, 0), c(0.1, 0.8, 0.1)),
               sample_weight = c(0.3, 0.7))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(1.6271976, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model \%>\% compile(
  optimizer = 'sgd',
  loss = 'mse',
  metrics = list(metric_categorical_crossentropy()))
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/metrics/probabilistic_metrics#categoricalcrossentropy-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr

Other probabilistic metrics: \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
}
\concept{losses}
\concept{metrics}
\concept{probabilistic metrics}
