% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_beta}
\alias{random_beta}
\title{Draw samples from a Beta distribution.}
\usage{
random_beta(shape, alpha, beta, dtype = NULL, seed = NULL)
}
\arguments{
\item{shape}{The shape of the random values to generate.}

\item{alpha}{Float or an array of floats representing the first
parameter alpha. Must be broadcastable with \code{beta} and \code{shape}.}

\item{beta}{Float or an array of floats representing the second
parameter beta. Must be broadcastable with \code{alpha} and \code{shape}.}

\item{dtype}{Optional dtype of the tensor. Only floating point types are
supported. If not specified, \code{config_floatx()} is used,
which defaults to \code{"float32"} unless you configured it otherwise (via
\code{config_set_floatx(float_dtype)}).}

\item{seed}{An integer or instance of
\code{random_seed_generator()}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or NULL (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{random_seed_generator()}.}
}
\value{
A tensor of random values.
}
\description{
The values are drawm from a Beta distribution parametrized
by alpha and beta.
}
\seealso{
Other random: \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
