% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_relu}
\alias{activation_relu}
\title{Applies the rectified linear unit activation function.}
\usage{
activation_relu(x, negative_slope = 0, max_value = NULL, threshold = 0)
}
\arguments{
\item{x}{Input tensor.}

\item{negative_slope}{A \code{numeric} that controls the slope
for values lower than the threshold.}

\item{max_value}{A \code{numeric} that sets the saturation threshold (the largest
value the function will return).}

\item{threshold}{A \code{numeric} giving the threshold value of the activation
function below which values will be damped or set to zero.}
}
\value{
A tensor with the same shape and dtype as input \code{x}.
}
\description{
With default values, this returns the standard ReLU activation:
\code{max(x, 0)}, the element-wise maximum of 0 and the input tensor.

Modifying default parameters allows you to use non-zero thresholds,
change the max value of the activation,
and to use a non-zero multiple of the input for values below the threshold.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- c(-10, -5, 0, 5, 10)
activation_relu(x)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([ 0.  0.  0.  5. 10.], shape=(5), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{activation_relu(x, negative_slope = 0.5)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([-5.  -2.5  0.   5.  10. ], shape=(5), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{activation_relu(x, max_value = 5)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0. 0. 0. 5. 5.], shape=(5), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{activation_relu(x, threshold = 5)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([-0. -0.  0.  0. 10.], shape=(5), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#relu-function}
}

Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
