% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covComp.R
\name{covComp}
\alias{covComp}
\title{Creator for the Class \code{"covComp"} for Composite Covariance
Kernels.}
\usage{
covComp(formula, where = .GlobalEnv, topParLower = NULL,
  topParUpper = NULL, trace = 0, ...)
}
\arguments{
\item{formula}{A formula. See \bold{Examples}.}

\item{where}{An environment where the covariance kernels objects
and top parameters will be looked for.}

\item{topParLower}{A numeric vector of lower bounds for the "top"
parameters.}

\item{topParUpper}{A numeric vector of upper bounds for the "top"
parameters.}

\item{trace}{Integer level of verbosity.}

\item{...}{Not used yet. For passing other slot values.}
}
\value{
An object with S4 class \code{"covComp"}.
}
\description{
Creator for the class "covComp" for Composite Covariance kernels.
}
\details{
A covariance object is built using \code{formula} which involves
kernel objects inheriting from the class \code{"covAll"} and
possibly of other scalar numeric parameters called \emph{top}
parameters. The formula can be thought of as involving the
covariance matrices rather than the kernel objects, each kernel
object say \code{obj} being replaced by \code{covMat(obj, X)} for
some design matrix or data frame \code{X}. Indeed, the sum or the
product of two kernel objects lead to a covariance which is simply
the sum or product of the kernel covariances. The top parameters
are considered as parameters of the covariance structure, as well
as the parameters of the covariance objects used in the
formula. Their value at the creation time will be used and thus
will serve as initial value in estimation.
}
\section{Caution}{
 The class definition and its creator are to
regarded as a DRAFT, many changes being necessary until a stable
implementation will be reached. The functions relating to this
class are not for final users of GP models, but rather to those
interested in the conception and specification in view of a future
release of the \bold{kergp} package.
}

\examples{
## =========================================================================
## build some kernels (with their inputNames) in the global environment
## =========================================================================

myCovExp3 <- kMatern(d = 3, nu = "1/2")
inputNames(myCovExp3) <- c("x", "y", "z")

myCovGauss2 <- kGauss(d = 2)
inputNames(myCovGauss2) <- c("temp1", "temp2")

k <- kMatern(d = 1)
inputNames(k) <- "x"

ell <- kMatern(d = 1)
inputNames(ell) <- "y"

tau2 <- 100
sigma2 <- 4

myCovComp <- covComp(formula = ~ tau2 * myCovGauss2() * myCovExp3() + sigma2 * k())

myCovComp1 <- covComp(formula = ~ myCovGauss2() * myCovExp3() + k())

inputNames(myCovComp)
coef(myCovComp)

n <- 5
set.seed(1234)
X <- data.frame(x = runif(n), y = runif(n), z = runif(n),
                temp1 = runif(n), temp2 = runif(n))

C <- covMat(myCovComp, X = X)

Cg <- covMat(myCovComp, X = X, compGrad = TRUE)

## Simulation: purely formal example, not meaningful.

Y <- simulate(myCovComp, X = X, nsim = 100)

}
