% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{cosNorm}
\alias{cosNorm}
\title{Cosine normalization of a kernel matrix}
\usage{
cosNorm(K)
}
\arguments{
\item{K}{Kernel matrix (class "matrix").}
}
\value{
Cosine-normalized K (class "matrix").
}
\description{
It is equivalent to compute K using the normalization `X/sqrt(sum(X^2))` in Feature Space.
}
\examples{
dat <- matrix(rnorm(250),ncol=50,nrow=5)
K <- Linear(dat)
cosNorm(K)
}
\references{
Ah-Pine, J. (2010). Normalized kernels as similarity indices.
In Advances in Knowledge Discovery and Data Mining: 14th Pacific-Asia Conference,
PAKDD 2010, Hyderabad, India, June 21-24, 2010. Proceedings. Part II 14 (pp. 362-373).
Springer Berlin Heidelberg. \href{https://hal.science/hal-01504523/document}{Link}
}
