% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Spectrum}
\alias{Spectrum}
\title{Spectrum kernel}
\usage{
Spectrum(
  x,
  alphabet,
  l = 1,
  group.ids = NULL,
  weights = NULL,
  feat_space = FALSE,
  cos.norm = FALSE
)
}
\arguments{
\item{x}{Vector of strings (length \emph{N}).}

\item{alphabet}{Alphabet of reference.}

\item{l}{Length of the substrings.}

\item{group.ids}{(optional) A vector with ids. It allows to compute the kernel
over groups of strings within x, instead of the individual strings.}

\item{weights}{(optional) A numeric vector as long as x. It allows to weight differently
each one of the strings.}

\item{feat_space}{If FALSE, only the kernel matrix is returned. Otherwise,
the feature space (i.e. a table with the number of times that a substring of
length \emph{l} appears in each string) is also returned (Defaults: FALSE).}

\item{cos.norm}{Should the resulting kernel matrix be cosine normalized? (Defaults: FALSE).}
}
\value{
Kernel matrix (dimension: \emph{NxN}), or a list with the kernel matrix and the
feature space.
}
\description{
`Spectrum()` computes the basic Spectrum kernel between strings. This kernel
computes the similarity of two strings by counting how many matching substrings
of length \emph{l} are present in each one.
}
\details{
In large datasets this function may be slow. In that case, you may use the `stringdot()`
function of the `kernlab` package, or the `spectrumKernel()` function of the `kebabs` package.
}
\examples{
## Examples of alphabets. _ stands for a blank space, a gap, or the
## start or the end of sequence)
NT <- c("A","C","G","T","_") # DNA nucleotides
AA <- c("A","C","D","E","F","G","H","I","K","L","M","N","P","Q","R","S","T",
"V","W","Y","_") ##canonical aminoacids
letters_ <- c(letters,"_")
## Example of data
strings <- c("hello_world","hello_word","hola_mon","kaixo_mundua",
"saluton_mondo","ola_mundo", "bonjour_le_monde")
names(strings) <- c("english1","english_typo","catalan","basque",
"esperanto","galician","french")
## Computing the kernel:
Spectrum(strings,alphabet=letters_,l=2)
}
\references{
Leslie, C., Eskin, E., and Noble, W.S.
The spectrum kernel: a string kernel for SVM protein classification.
Pac Symp Biocomput. 2002:564-75. PMID: 11928508.
\href{http://psb.stanford.edu/psb-online/proceedings/psb02/abstracts/p564.html}{Link}
}
