% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{visualize_keywords}
\alias{visualize_keywords}
\title{Visualize keywords}
\usage{
visualize_keywords(docs, keywords, prune = TRUE, label_size = 3.2)
}
\arguments{
\item{docs}{a keyATM_docs object, generated by \code{keyATM_read()} function}

\item{keywords}{a list of keywords}

\item{prune}{logical. If \code{TRUE}, prune keywords that do not appear in \code{docs}. Default is \code{TRUE}.}

\item{label_size}{the size of keyword labels in the output plot. Default is \code{3.2}.}
}
\value{
keyATM_fig object
}
\description{
Visualize the proportion of keywords in the documents.
}
\examples{
\dontrun{
 # Prepare a keyATM_docs object
 keyATM_docs <- keyATM_read(input)

 # Keywords are in a list
 keywords <- list(Education = c("education", "child", "student"),
                  Health    = c("public", "health", "program"))

 # Visualize keywords
 keyATM_viz <- visualize_keywords(keyATM_docs, keywords)

 # View a figure
 keyATM_viz

 # Save a figure
 save_fig(keyATM_viz, filename)
}
}
\seealso{
\code{\link[=save_fig]{save_fig()}}
}
