#' Literature word list
#'
#' Word list generated by processing several works of literature on
#' Project Gutenberg
#'
#' @docType data
#'
#' @usage data(wl_literature)
#'
#' @format An object of class `character`
#'
#' @keywords datasets
#'
#' @references Project Gutenberg.
#' \href{https://gutenberg.org}{Project Gutenberg}
#'
#' @examples
#' data(wl_literature)
#' keyToEnglish(1:5, word_list=wl_literature)
"wl_literature"

#' Science word list
#'
#' Word list generated by processing several science-related pages
#' on Wikipedia
#'
#' @docType data
#'
#' @usage data(wl_science)
#'
#' @format An object of class `character`
#'
#' @keywords datasets
#'
#'
#' @examples
#' data(wl_science)
#' keyToEnglish(1:5, word_list=wl_science)
"wl_science"

#' Animal word list
#'
#' Word list generated by processing several animal-related pages
#' on Wikipedia
#'
#' @docType data
#'
#' @usage data(wl_animal)
#'
#' @format An object of class `character`
#'
#' @keywords datasets
#'
#'
#' @examples
#' data(wl_animal)
#' keyToEnglish(1:5, word_list=wl_animal)
"wl_animal"

#' Common word list
#'
#' Public domain word list of common words
#'
#' @docType data
#'
#' @usage data(wl_common)
#'
#' @format An object of class `character`
#'
#' @keywords datasets
#'
#' @references Public Domain Word Lists. Michael Wehar
#' \href{https://github.com/MichaelWehar/Public-Domain-Word-Lists}{https://github.com/MichaelWehar/Public-Domain-Word-Lists}
#'
#' @examples
#' data(wl_common)
#' keyToEnglish(1:5, word_list=wl_common)
"wl_common"

#' Freq 5663 word list
#'
#' Public domain word list of common words, slightly truncated
#' from original version
#'
#' @docType data
#'
#' @usage data(wl_freq5663)
#'
#' @format An object of class `character`
#'
#' @keywords datasets
#'
#' @references Public Domain Word Lists. Michael Wehar
#' \href{https://github.com/MichaelWehar/Public-Domain-Word-Lists}{https://github.com/MichaelWehar/Public-Domain-Word-Lists}
#'
#' @examples
#' data(wl_common)
#' keyToEnglish(1:5, word_list=wl_freq5663)
"wl_freq5663"



