% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyToEnglish.R
\name{keyToEnglish}
\alias{keyToEnglish}
\title{Key to English}
\usage{
keyToEnglish(
  x,
  hash_function = "md5",
  phrase_length = 5,
  corpus_path = NA,
  word_list = wl_common,
  hash_subsection_size = 3,
  sep = "",
  word_trans = "camel",
  suppress_warning = FALSE
)
}
\arguments{
\item{x}{- field to hash}

\item{hash_function}{`character` name of hash function or hash `function` itself,
returning a hexadecimal character}

\item{phrase_length}{`numeric` of words to use in each hashed key}

\item{corpus_path}{`character` path to word list, as a single-column text file with one
word per row}

\item{word_list}{`character` list of words to use in phrases}

\item{hash_subsection_size}{`numeric` length of each subsection of hash to use for word index. 16^N
unique words can be used for a size of N. This value times
phrase_length must be less than or equal to the length of the
hash output.}

\item{sep}{`character` separator to use between each word.}

\item{word_trans}{A `function`, `list` of functions, or 'camel' (for CamelCase). If
a list is used, then the index of the word of each phrase is
mapped to the corresponding function with that index,
recycling as necessary}

\item{suppress_warning}{`logical` value indicating if warning of non-character
input should be suppressed}
}
\value{
`character` vector of hashed field resembling phrases
}
\description{
Hashes field to sequence of words from a list.
}
\examples{
# hash the numbers 1 through 5
keyToEnglish(1:5)

# alternate upper and lowercase, 3 words only
keyToEnglish(1:5, word_trans=list(tolower, toupper), phrase_length=3)
}
