% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{fragment}
\alias{fragment}
\title{Compute the Fragmentation Centrality Score in a Netwrok}
\usage{
fragment(adj.matrix, nodes, M = Inf, binary = FALSE)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If there are multiple players,
use \code{c(index1,index2,...)}.
If not specified, scores for all nodes will be reported.}

\item{M}{Number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected.
M hence defines the reachable set. The default is \code{Inf}.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. The default is \code{FALSE}.}
}
\value{
Vector indicating fragment score(s) of the chosen player(s).
Score is normalized to [0,1].
}
\description{
\code{fragment} measures the extent of fragmentation of a network after a
set of nodes is removed from the network. The more the fregmentation level of
the residual network is, the more central those nodes are.
}
\details{
A natural way to apply the fragmentation centrality is in the
context of counter-terrorism, as originally proposed in Borgatti (2006).
The measure uses geodistances to compute the fragmentation level of the
residual network, and thus edge values should be properly adjusted to
distance interpretation. The fragmentation centrality is not directional
as edge values are counted aggregately in a network level. \code{fragment}
keeps the flexible features of defining reachable set using M, discribed in
\code{\link{mreach.degree}} and \code{\link{mreach.closeness}}.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to distance interpretaion
A <- W
A[W!=0] <- 1/W[W!=0]

# List the fragmentation centrality scores for every node
fragment(A)
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
Borgatti, Stephen P. 2006. "Identifying Sets of Key Players in a Network."
\emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr
}
\seealso{
\code{\link[sna]{geodist}};
\code{\link{kpcent}};
\code{\link{kpset}}
}

