% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Syntax-Functions.R
\name{efa_cfa_syntax}
\alias{efa_cfa_syntax}
\title{Write confirmatory factor analysis syntax}
\usage{
efa_cfa_syntax(
  loadings,
  simple = TRUE,
  threshold = NA,
  single.item = c("keep", "drop", "none"),
  identified = TRUE,
  constrain0 = FALSE
)
}
\arguments{
\item{loadings}{matrix of factor loadings}

\item{simple}{logical; Should the simple structure be returned (default)?
If \code{FALSE}, items can cross-load on multiple factors.}

\item{threshold}{numeric between 0 and 1 indicating the minimum (absolute) value
of the loading for an item on a factor. Must be specified when \code{simple = FALSE}}

\item{single.item}{character indicating how single-item factors should be treated.
Use \code{"keep"} (default) to keep them in the model when generating the CFA syntax, \code{"drop"}
to remove them, or \code{"none"} indicating the CFA syntax should not be generated for
this model and \code{""} will be returned.}

\item{identified}{logical; Should identification check for rotational uniqueness a la Millsap (2001) be performed?}

\item{constrain0}{logical; Should variable(s) with all loadings below \code{threshold} still be included in model syntax?
If \code{TRUE}, variable(s) will load onto first factor with the loading constrained to 0.}
}
\description{
Uses the factor loadings matrix, presumably from an exploratory factor analysis, to generate lavaan compatible confirmatory factory analysis syntax.
}
\examples{
loadings <- matrix(c(rep(.2, 3), rep(.6, 3), rep(.8, 3), rep(.3, 3)), ncol = 2)
efa_cfa_syntax(loadings) # simple structure
efa_cfa_syntax(loadings, simple = FALSE, threshold = .25) # allow cross-loadings

}
