% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_discrete}
\alias{scale_tol_discrete}
\alias{scale_fill_muted}
\title{Paul Tol's Discrete Color Schemes for \pkg{ggplot2} and \pkg{ggraph}}
\usage{
scale_fill_muted(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Provides qualitative color scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
\tabular{ll}{
\strong{Palette} \tab \strong{Max.} \cr
\code{bright} \tab 7 \cr
\code{highcontrast} \tab 3 \cr
\code{vibrant} \tab 7 \cr
\code{muted} \tab 9 \cr
\code{mediumcontrast} \tab 6 \cr
\code{pale} \tab 6 \cr
\code{dark} \tab 6 \cr
\code{light} \tab 9 \cr
}
}
\section{Interpolation}{

The qualitative color schemes are used as given (no interpolation):
colors are picked up to the maximum number of supported values.
}

\section{Qualitative Color Schemes}{

According to Paul Tol's technical note, the \code{bright}, \code{highcontrast},
\code{vibrant} and \code{muted} color schemes are color-blind safe. The
\code{mediumcontrast} color scheme is designed for situations needing color
pairs.

The \code{light} color scheme is reasonably distinct for both normal or
colorblind vision and is intended to fill labeled cells.

The \code{pale} and \code{dark} schemes are not very distinct in either normal or
colorblind vision and should be used as a text background or to highlight
a cell in a table.

Refer to the original document for details about the recommended uses (see
references).
}

\examples{
library(ggplot2)

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_bright()

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_vibrant()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_muted()
}
\references{
Tol, P. (2021). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.2.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other color-blind safe color schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{color-blind safe color schemes}
\keyword{internal}
