% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_similarity_matrix.R
\name{kmeRs_similarity_matrix}
\alias{kmeRs_similarity_matrix}
\title{Pairwise Similarity Matrix}
\usage{
kmeRs_similarity_matrix(
  q = NULL,
  x = NULL,
  align.type = "global",
  k = 3,
  seq.type = "AA",
  submat = ifelse(test = (match.arg(toupper(seq.type), c("DNA", "AA")) == "AA"), yes =
    "BLOSUM62", no = NA),
  compare.all = FALSE,
  save_to_file = NULL,
  ...
)
}
\arguments{
\item{q}{query vector with given k-mers}

\item{x}{kmers to search the query vector against. If unspecified, \code{q} will 
be compared to either other k-mers within \code{q} (\code{compare.all = FALSE}),
or all possible combinations specified by the parameter \code{k}}

\item{align.type}{type of alignment, either \code{global} or \code{local}.
\code{global} uses Needleman-Wunsch global alignment to calculate scores, while
\code{local} represents Smith-Waterman local alignment instead}

\item{k}{length of k-mers to calculate the similarity matrix for, defaults to 3; e.g. for DNA, N = 4^3 = 64 combinations if \code{k = 3};}

\item{seq.type}{type of sequence in question, either 'DNA' or 'AA' (default);
this will also modify \code{q} accordingly, if \code{q} is unspecified.}

\item{submat}{substitution matrix, default to 'BLOSUM62'; other choices are
'BLOSUM45', 'BLOSUM50', 'BLOSUM62', 'BLOSUM80', 'BLOSUM100', 'PAM30',
'PAM40', 'PAM70', 'PAM120' or 'PAM250'}

\item{compare.all}{if \code{TRUE}, the query vector will be compared to all
possible combinations of k-mers (defaults to \code{FALSE})}

\item{save_to_file}{if specified, the results will be saved to the path in
comma-separated format (.CSV)}

\item{...}{other parameters, e.g. gap opening/extension penalties (\code{gapOpening},
\code{gapExtension}), or DNA match/mismatch scores (\code{na.match}, \code{na.mismatch})}
}
\value{
similarity matrix is returned as a data.frame
}
\description{
The \code{kmeRs_similarity_matrix} function generates a pairwise similarity score
matrix for for k length given k-mers vs. all possible k-mers combination.
The pairwise similarity score is calculated using PAM or BLOSUM substitution matrix;
30, 40, 70, 120, 250 and 62, 45, 50, 62, 80, 100 matrix versions are available for
PAM or BLOSUM, respectively. The results are evaluated by global similarity score;
higher similarity score indicates more similar sequences for BLOSUM and opposite for
PAM matrix.
}
\examples{
# Simple BLOSUM62 similarity matrix for all amino acid nucleotides
kmeRs_similarity_matrix(submat = "BLOSUM62")

}
