% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustheatmap.R
\name{clustheatmap}
\alias{clustheatmap}
\title{Consensus matrix heatmap from A consensus matrix}
\usage{
clustheatmap(consmat, title = "")
}
\arguments{
\item{consmat}{A matrix of consensus matrix.}

\item{title}{A character of plot title}
}
\value{
Function returns a heatmap plot.
}
\description{
This function create a consensus matrix heatmap from a consensus
matrix.
}
\details{
This is a function to produce a consensus matrix heatmap from a consensus
matrix.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
parkboot <- function(x, nclust) {
res <- fastkmed(x, nclust, iterate = 50)
return(res$cluster)
}
irisboot <- clustboot(mrwdist, nclust=3, parkboot, nboot=7)
wardorder <- function(x, nclust) {
res <- hclust(x, method = "ward.D2")
member <- cutree(res, nclust)
return(member)
}
consensusiris <- consensusmatrix(irisboot, nclust = 3, wardorder)
clustheatmap(consensusiris)

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
