% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv}
\alias{csv}
\title{Centroid shadow value (CSV) index and plot}
\usage{
csv(distdata, idmedoid, idcluster, title = "")
}
\arguments{
\item{distdata}{A distance matrix (\emph{n x n}) or \emph{dist} object.}

\item{idmedoid}{A vector of id medoids (\emph{see} \strong{Details}).}

\item{idcluster}{A vector of cluster membership (\emph{see} \strong{Details}).}

\item{title}{A title of the plot.}
}
\value{
Function returns a list with following components:

\code{result} is a data frame of the shadow values for all objects

\code{plot} is the shadow value plots of each cluster.
}
\description{
This function computes shadow values and shadow value plots of
each cluster. The plot presents the mean of the shadow values as well.
}
\details{
The origin of the shadow value is calculated in the \code{shadow}
function of the \pkg{flexclust} package, in which it is based on the first and
second closest centroid. The \code{csv} function in this package modifies
the centroid into medoid such that the formula to compute shadow value of
object \emph{i} is
\deqn{sh(i) = \frac{2d(i, m(i))}{d(i, m(i)) + d(i, m'(i))}}
where \eqn{d(i, m(i))} is the distance between object \emph{i} to the first
closest medoid and \emph{d(i, m'(i))} is the distance between object
\emph{i} to the second closest medoid.

The \code{idmedoid} argument corresponds to the \code{idcluster} argument.
If the length of \code{idmedoid} is 3, for example, the \code{idcluster} has
to have 3 unique cluster memberships, or it returns \code{Error} otherwise.
The length of the \code{idcluster} has also to be equal to \emph{n}
(the number of objects).
}
\examples{
distiris <- as.matrix(dist(iris[,1:4]))
res <- fastkmed(distiris, 3)
sha <- csv(distiris, res$medoid, res$cluster)
sha$result[c(1:3,70:75,101:103),]
sha$plot

}
\references{
F. Leisch. 2010 Neighborhood graphs, stripes and shadow plots
for cluster visualization. Statistics and Computing. vol. 20, pp. 457-469
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
