% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{download_image}
\alias{download_image}
\title{Download an image from the web and include it in a document}
\usage{
download_image(
  url,
  path = xfun::url_filename(url),
  use_file = !pandoc_to("html"),
  ...
)
}
\arguments{
\item{url}{The URL of an image.}

\item{path}{The download path (inferred from the URL by default). If the file
exists, it will not be downloaded (downloading can take time and requires
Internet connection). If you are sure the file needs to be downloaded
again, delete it beforehand.}

\item{use_file}{Whether to use the URL or the download path to include the
image. By default, the URL is used for HTML output formats, and the file
path is used for other output formats.}

\item{...}{Other arguments to be passed to \code{\link{include_graphics}()}.}
}
\description{
When including images in non-HTML output formats such as LaTeX/PDF, URLs will
not work as image paths. In this case, we have to download the images. This
function is a wrapper of \code{xfun::\link[xfun]{download_file}()} and
\code{\link{include_graphics}()}.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
knitr::download_image("https://www.r-project.org/Rlogo.png")
\dontshow{\}) # examplesIf}
}
