% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l1_spectral.R
\name{l1_spectral}
\alias{l1_spectral}
\title{Run the l1-spectral clustering algorithm on one component}
\usage{
l1_spectral(A, k, elements, pen, stab = TRUE)
}
\arguments{
\item{A}{The adjacency matrix of the graph to cluster.}

\item{k}{The number of clusters.}

\item{elements}{The representative elements of the connected component to cluster.}

\item{pen}{The penalty (to be chosen among "lasso" and "thresholdedLS").}

\item{stab}{TRUE/FALSE indicating whether the representative elements should be stabilized (TRUE by default).}
}
\value{
The matrix of community indicators.
}
\description{
This function runs the l1-spectral clustering algorithm on one component only.
}
\examples{
 #########################################################
 # Performing the l1-spectral clustering on one component
 #########################################################

 # 1st: create data
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.1,p_outside=0.1))

 # 2nd: find the structure, the opt number of clusters and the representative elements
 Structure <- FindStructure(Data$A_hat)
 Clusters <- FindNbrClusters(A = Data$A_hat, structure = Structure)
 Elements <- FindElement(A = Data$A_hat, structure = Structure, clusters = Clusters)

 Structure_tmp <- Structure$groups[[1]] # the first component
 A_tmp <- Data$A_hat[Structure$groups[[1]],Structure$groups[[1]]]
 k <- Clusters$nbr_clusters$Component1 # number of clusters to create
 Elements_tmp <- list(score = Elements$score$Component1,
                      indices = Elements$indices$Component1)
       # the elements of the first component

 # 3rd: perform the l1-spectral clustering algorithm
 # (with stabilization, which is the most recommended setting)
 comm <- l1_spectral(A = A_tmp, k = k, elements = Elements_tmp, pen = "lasso", stab=TRUE)
}
\seealso{
\code{\link{l1_spectralclustering}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
\keyword{internal}
