% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-handling.R
\name{condition}
\alias{condition}
\title{Define a condition (like an error) with support for HTTP status codes}
\usage{
condition(subclass, ..., code = 500L, request_id = NULL, call = sys.call(-1))
}
\arguments{
\item{subclass}{conditions returned by this function will be of the class
\code{c(subclass, "simpleError", "error", "condition")}.}

\item{...}{zero or more objects which can be coerced to character (and which
are pasted together with no separator). This forms the error message.}

\item{code}{HTTP status code to return (if applicable). Defaults to \code{500},
which is a generic "Internal Server Error". This is used when errors are to
be returned to an API Gateway.}

\item{request_id}{character. Used in error handling during event
decomposition, when it's possible that a request ID might be known but the
event hasn't been fully examined yet.}

\item{call}{call expression}
}
\description{
For more information on conditions and errors see
\url{http://adv-r.had.co.nz/Exceptions-Debugging.html}. See also
\code{\link[base]{conditions}}.
}
\keyword{internal}
