% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_core_mn.R
\name{lsm_l_core_mn}
\alias{lsm_l_core_mn}
\title{CORE_MN (landscape level)}
\usage{
lsm_l_core_mn(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Mean of core area (Core area metric)
}
\details{
\deqn{CORE_{MN} = mean(CORE[patch_{ij}])}
where \eqn{CORE[patch_{ij}]} is the core area in square meters of each patch.

CORE_MN is a 'Core area metric' and equals the mean of core areas of all patches
in the landscape. The core area is defined as all cells that have no
neighbour with a different value than themselves (rook's case).

\subsection{Units}{Hectares}
\subsection{Range}{CORE_MN >= 0}
\subsection{Behaviour}{Equals CORE_MN = 0 if CORE = 0 for all patches. Increases,
without limit, as the core area indices increase.}
}
\examples{
lsm_l_core_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_core}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_core_mn}},
\code{\link{lsm_c_core_sd}},
\code{\link{lsm_c_core_cv}}, \cr
\code{\link{lsm_l_core_sd}},
\code{\link{lsm_l_core_cv}}
}
