% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_shape_mn.R
\name{lsm_l_shape_mn}
\alias{lsm_l_shape_mn}
\title{SHAPE_MN (landscape level)}
\usage{
lsm_l_shape_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean shape index (Shape metric)
}
\details{
\deqn{SHAPE_{MN} = mean(SHAPE[patch_{ij}])}
where \eqn{SHAPE[patch_{ij}]} is the shape index of each patch.

SHAPE_MN is a 'Shape metric'. The landscape is summarised as the mean
of all patches in the landscape. SHAPE describes the ratio between the actual perimeter
of the patch and the hypothetical minimum perimeter of the patch. The minimum perimeter
equals the perimeter if the patch would be maximally compact.

\subsection{Units}{None}
\subsection{Range}{SHAPE_SD >= 1}
\subsection{Behaviour}{Equals SHAPE_MN = 0 if all patches are squares.
Increases, without limit, as the shapes of patches become more complex.}
}
\examples{
lsm_l_shape_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_shape_mn}},
\code{\link{lsm_c_shape_sd}},
\code{\link{lsm_c_shape_cv}}, \cr
\code{\link{lsm_l_shape_sd}},
\code{\link{lsm_l_shape_cv}}
}
