% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_core_sd.R
\name{lsm_c_core_sd}
\alias{lsm_c_core_sd}
\title{CORE_SD (class level)}
\usage{
lsm_c_core_sd(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Standard deviation patch core area (class level)
}
\details{
\deqn{CORE_{SD} = sd(CORE[patch_{ij}])}
where \eqn{CORE[patch_{ij}]} is the core area in square meters of each patch.

CORE_SD is a 'Core area metric'. It equals the standard deviation of the core area
of each patch belonging to class i. The core area is defined as all cells that have no
neighbour with a different value than themselves (rook's case). The metric describes the
differences among patches of the same class i in the landscape.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Hectares}
\subsection{Range}{CORE_SD >= 0}
\subsection{Behaviour}{Equals CORE_SD = 0 if all patches have the same core area.
Increases, without limit, as the variation of patch core areas increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_core_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_core}},
\code{\link[stats]{sd}} \cr
\code{\link{lsm_c_core_mn}},
\code{\link{lsm_c_core_cv}}, \cr
\code{\link{lsm_l_core_mn}},
\code{\link{lsm_l_core_sd}},
\code{\link{lsm_l_core_cv}}
}
