% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lang.R
\name{get_lang}
\alias{get_lang}
\title{Get language}
\usage{
get_lang(query, api_key = NULL)
}
\arguments{
\item{query}{the character string you want to detect the language from.}

\item{api_key}{your API key.}
}
\value{
Returns a data.frame with the detected languages, in descending order of probability. Values are : language_code, language_name, probability (length of the provided query text and how well it is identified as a language), percentage (confidence margin between multiple matches), and reliable_result (whether or not the API is completely confident about the main match).
}
\description{
Detect language from a character string.
}
\details{
Takes a character string, returns a data.frame with the available values.
}
\note{
Before running a function of this package for the first time, you need to set your API key using the \code{\link{setApiKey}} function.
}
\examples{
get_lang(query = "I really really love R and that's a good thing, right?", api_key = "apikey")
}
