% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{cleanText}
\alias{cleanText}
\title{Clean text}
\usage{
cleanText(text, spaces = TRUE, lower = TRUE, ascii = TRUE, title = FALSE)
}
\arguments{
\item{text}{Character Vector}

\item{spaces}{Boolean. Keep spaces? If character input, spaces
will be transformed into passed argument.}

\item{lower}{Boolean. Transform all to lower case?}

\item{ascii}{Boolean. Only ASCII characters?}

\item{title}{Boolean. Transform to title format (upper case on first letters)}
}
\value{
Character vector with transformed strings.
}
\description{
This function lets the user clean text into getting only alphanumeric
characters and no accents/symbols on letters.
}
\examples{
cleanText("Bernardo Lares 123")
cleanText("Bèrnärdo LáreS 123", lower = FALSE)
cleanText("Bernardo Lare$", spaces = ".", ascii = FALSE)
cleanText("\\\\@®ì÷å   \%ñS  ..-X", spaces = FALSE)
cleanText(c("maría", "€", "núñez_a."), title = TRUE)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()}

Other Text Mining: 
\code{\link{cleanNames}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Data Wrangling}
\concept{Text Mining}
